#include <winsock2.h>
#include <windows.h>
#include "memcachedCOM_h.h"
#include <atlbase.h>
#include <sstream>



#ifdef _WIN64
#import <C:\Program Files\Common Files\System\ado\msado15.dll> raw_interfaces_only, no_smart_pointers
#import <C:\WINDOWS\system32\scrrun.dll> raw_interfaces_only, no_smart_pointers, rename("DeleteFile", "SR_DeleteFile"), rename("MoveFile", "SR_MoveFile"), rename("CopyFile", "SR_CopyFile")
#else
#import <C:\Program Files (x86)\Common Files\System\ado\msado15.dll> raw_interfaces_only, no_smart_pointers
#import <C:\WINDOWS\SysWOW64\scrrun.dll> raw_interfaces_only, no_smart_pointers, rename("DeleteFile", "SR_DeleteFile"), rename("MoveFile", "SR_MoveFile"), rename("CopyFile", "SR_CopyFile")
#endif









template<
	class		TI,
	template<class TI> class TImpl,
	ITypeInfo*&	t_pTypeInfo,
	long*		t_pRefCount
>
class GDualImpl
	: public TImpl<TI>
{
protected:
	long m_nRefCount;

public:
	GDualImpl()
		: m_nRefCount(0)
	{
		::InterlockedIncrement(t_pRefCount);
	}

	~GDualImpl()

	{
		::InterlockedDecrement(t_pRefCount);
	}

protected:
// IUnknown
	virtual HRESULT STDMETHODCALLTYPE QueryInterface( 
        /* [in] */ REFIID riid,
        /* [iid_is][out] */ void __RPC_FAR *__RPC_FAR *ppvObject)
	{
		if(::IsEqualGUID(IID_IUnknown, riid))
		{
			*ppvObject = static_cast<IUnknown*>(static_cast<IDispatch*>(this));
		}
		else
		if(::IsEqualGUID(IID_IDispatch, riid))
		{
			*ppvObject = static_cast<IDispatch*>(this);
		}
		else
		if(::IsEqualGUID(__uuidof(TI), riid))
		{
			*ppvObject = static_cast<TI*>(this);
		}
		else
		{
//			return E_NOINTERFACE;
			return TImpl<TI>::QueryInterface(riid, ppvObject);
		}

		AddRef();

		return S_OK;
	}
    
    virtual ULONG STDMETHODCALLTYPE AddRef( void)
	{
		return ++m_nRefCount;
	}
    
    virtual ULONG STDMETHODCALLTYPE Release( void)
	{
		if(!--m_nRefCount)
		{
			delete this;
			return 0;
		}

		return m_nRefCount;
	}

// IDispatch
    virtual HRESULT STDMETHODCALLTYPE GetTypeInfoCount( 
        /* [out] */ UINT *pctinfo)
	{
		return 1;
	}
    
    virtual HRESULT STDMETHODCALLTYPE GetTypeInfo( 
        /* [in] */ UINT iTInfo,
        /* [in] */ LCID lcid,
        /* [out] */ ITypeInfo **ppTInfo)
	{
		*ppTInfo = t_pTypeInfo, (*ppTInfo)->AddRef();

		return S_OK;
	}
    
    virtual HRESULT STDMETHODCALLTYPE GetIDsOfNames( 
        /* [in] */ REFIID riid,
        /* [size_is][in] */ LPOLESTR *rgszNames,
        /* [in] */ UINT cNames,
        /* [in] */ LCID lcid,
        /* [size_is][out] */ DISPID *rgDispId)
	{
		return t_pTypeInfo->GetIDsOfNames(rgszNames, cNames, rgDispId);
	}
    
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Invoke( 
        /* [in] */ DISPID dispIdMember,
        /* [in] */ REFIID riid,
        /* [in] */ LCID lcid,
        /* [in] */ WORD wFlags,
        /* [out][in] */ DISPPARAMS *pDispParams,
        /* [out] */ VARIANT *pVarResult,
        /* [out] */ EXCEPINFO *pExcepInfo,
        /* [out] */ UINT *puArgErr)
	{
		return t_pTypeInfo->Invoke(static_cast<TI*>(this), dispIdMember, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
	}

};
//---



template <
	typename	TTarget,
	long*		t_pRefCount
>
class GClassFactory
	: public IClassFactory
{
protected:
// IUnknown
	virtual HRESULT STDMETHODCALLTYPE QueryInterface( 
        /* [in] */ REFIID riid,
        /* [iid_is][out] */ void __RPC_FAR *__RPC_FAR *ppvObject)
	{
		if(::IsEqualGUID(IID_IUnknown, riid))
		{
			*ppvObject = static_cast<IUnknown*>(this);
		}
		else
		if(::IsEqualGUID(IID_IClassFactory, riid))
		{
			*ppvObject = static_cast<IClassFactory*>(this);
		}
		else
		{
			return E_NOINTERFACE;
		}

		AddRef();

		return S_OK;
	}
    
    virtual ULONG STDMETHODCALLTYPE AddRef( void)
	{
		return ::InterlockedIncrement(t_pRefCount);
	}
    
    virtual ULONG STDMETHODCALLTYPE Release( void)
	{
		return ::InterlockedDecrement(t_pRefCount);
	}
    
// IClassFactory
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE CreateInstance( 
        /* [unique][in] */ IUnknown *pUnkOuter,
        /* [in] */ REFIID riid,
        /* [iid_is][out] */ void **ppvObject)
	{
		if(pUnkOuter) return CLASS_E_NOAGGREGATION;

		IUnknown* pTarget = static_cast<IUnknown*>(static_cast<IDispatch*>(new TTarget));
		if(!pTarget) return E_OUTOFMEMORY;

		pTarget->AddRef();

		HRESULT hr = pTarget->QueryInterface(riid, ppvObject);
		
		pTarget->Release();

		return hr;
	}
    
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE LockServer( 
        /* [in] */ BOOL fLock)
	{
		return S_OK;
	}

};
//---









HRESULT RaiseError(HRESULT hr, const wchar_t* pSource, const wchar_t* pDescription)
{
    CComPtr<ICreateErrorInfo> pICEI;
	if (SUCCEEDED(::CreateErrorInfo(&pICEI)))
    {
		pICEI->SetSource(const_cast<wchar_t*>(pSource));
		pICEI->SetDescription(const_cast<wchar_t*>(pDescription));

		CComPtr<IErrorInfo> pErrorInfo;

		if( SUCCEEDED(pICEI->QueryInterface(IID_IErrorInfo, (void**)&pErrorInfo)) )
			::SetErrorInfo(0, pErrorInfo);
    }

	return hr;
}
//---









HRESULT MD5(const BYTE* pData, const DWORD& dwSize, BSTR* pResult)
{
	HRESULT hr = E_FAIL;

	HCRYPTPROV hCryptProv = NULL;
	HCRYPTHASH hHash = NULL;

	if(
		::CryptAcquireContextW(&hCryptProv, NULL, NULL, PROV_RSA_FULL, CRYPT_VERIFYCONTEXT | CRYPT_MACHINE_KEYSET) &&
		::CryptCreateHash(hCryptProv, CALG_MD5, 0, 0, &hHash) &&
		::CryptHashData(hHash, pData, dwSize, 0)
	)
	{
		BYTE bHash[0x10]; 
		DWORD dwHashLen= sizeof(bHash);

		if(::CryptGetHashParam(hHash, HP_HASHVAL, bHash, &dwHashLen, 0))
		{
			wchar_t aDigest[0x20 + 1];

			for(DWORD i=0; i<dwHashLen; ++i)
			{
				::swprintf_s(&aDigest[2*i], 3, L"%02x", bHash[i]);
			}

			aDigest[0x20] = L'\0';	// KNULLƂ

			*pResult = ::SysAllocString(aDigest);

			hr = S_OK;
		}
	}

	::CryptDestroyHash(hHash);
	::CryptReleaseContext(hCryptProv, 0);

	return hr;
}
//--








template<typename T>
class GImemcachedCOMImpl
	: public T
	, public IStream
{
protected:
	SOCKET	m_oSocket;

	std::stringstream	m_ssmBuf;



public:
	GImemcachedCOMImpl()
		: m_oSocket(INVALID_SOCKET)
	{
	}

	~GImemcachedCOMImpl()
	{
		Close();
	}



protected:
	HRESULT CalcKey(ADODB::_Command* pCommand, BSTR* pKey)
	{
		HRESULT hr = E_FAIL;



		BYTE aBuf[0x80][0x40] = { 0 };
		{
			ATL::CComBSTR sCmdTxt;
			ATL::CComBSTR sMD5;
			if( 
				SUCCEEDED(hr = pCommand->get_CommandText(&sCmdTxt))													&&
				SUCCEEDED(hr = MD5((const BYTE*)sCmdTxt.m_str, sizeof(sCmdTxt.m_str[0])*sCmdTxt.Length(), &sMD5))	&&
				true)
			{
				::memcpy_s(aBuf[0], 0x40, (const void*)sMD5.m_str, sizeof(sMD5.m_str[0])*sMD5.Length());



				ATL::CComPtr<ADODB::Parameters> ptrParams;
				long nParams;
				if( 
					SUCCEEDED(hr = pCommand->get_Parameters(&ptrParams))	&&
					SUCCEEDED(hr = ptrParams->get_Count(&nParams))			&&
					SUCCEEDED(hr = ((1+nParams < 0x80) ? S_OK : ::RaiseError(E_FAIL, L"memcachedCOM", L"Too many command parameter.")))	&&
					true)
				{
					hr = S_OK;

					for(long i=0; i<nParams; ++i)
					{
						ATL::CComPtr<ADODB::_Parameter> ptrParam;
						ATL::CComVariant vValue;
						if( 
							SUCCEEDED(hr = ptrParams->get_Item(ATL::CComVariant(i), &ptrParam))	&&
							SUCCEEDED(hr = ptrParam->get_Value(&vValue))						&&
							true)
						{
							VARIANT* pVarBuf = reinterpret_cast<VARIANT*>( &aBuf[1+i] );

							if(vValue.vt == VT_BSTR)
							{
								long nLen = ::SysStringLen(vValue.bstrVal);
								if( sizeof(vValue.bstrVal[0])*nLen <= 0x40 )
								{
									::memcpy_s(aBuf[1+i], 0x40, vValue.bstrVal, sizeof(vValue.bstrVal[0])*nLen);
								}
								else
								{
									ATL::CComBSTR sParamMD5;
									if( SUCCEEDED(hr = MD5((const BYTE*)vValue.bstrVal, sizeof(vValue.bstrVal[0])*nLen, &sParamMD5)) )
									{
										::memcpy_s(aBuf[1+i], 0x40, (const void*)sParamMD5.m_str, sizeof(sParamMD5.m_str[0])*sParamMD5.Length());
									}
									else
									{
										hr = E_FAIL;
										break;
									}
								}
							}
							else
							if(V_VT(&vValue) == VT_EMPTY)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
							}
							else
							if(V_VT(&vValue) == VT_NULL)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
							}
							else
							if(V_VT(&vValue) == VT_I2)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_I2(pVarBuf), 0x40-0x08, &V_I2(&vValue), sizeof(V_I2(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_I4)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_I4(pVarBuf), 0x40-0x08, &V_I4(&vValue), sizeof(V_I4(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_R4)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_R4(pVarBuf), 0x40-0x08, &V_R4(&vValue), sizeof(V_R4(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_R8)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_R8(pVarBuf), 0x40-0x08, &V_R8(&vValue), sizeof(V_R8(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_CY)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_CY(pVarBuf), 0x40-0x08, &V_CY(&vValue), sizeof(V_CY(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_DATE)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_DATE(pVarBuf), 0x40-0x08, &V_DATE(&vValue), sizeof(V_DATE(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_ERROR)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_ERROR(pVarBuf), 0x40-0x08, &V_ERROR(&vValue), sizeof(V_ERROR(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_BOOL)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_BOOL(pVarBuf), 0x40-0x08, &V_BOOL(&vValue), sizeof(V_BOOL(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_I1)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_I1(pVarBuf), 0x40-0x08, &V_I1(&vValue), sizeof(V_I1(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_UI1)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_UI1(pVarBuf), 0x40-0x08, &V_UI1(&vValue), sizeof(V_UI1(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_UI2)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_UI2(pVarBuf), 0x40-0x08, &V_UI2(&vValue), sizeof(V_UI2(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_UI4)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_UI4(pVarBuf), 0x40-0x08, &V_UI4(&vValue), sizeof(V_UI4(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_I8)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_I8(pVarBuf), 0x40-0x08, &V_I8(&vValue), sizeof(V_I8(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_UI8)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_UI8(pVarBuf), 0x40-0x08, &V_UI8(&vValue), sizeof(V_UI8(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_INT)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_INT(pVarBuf), 0x40-0x08, &V_INT(&vValue), sizeof(V_INT(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_UINT)
							{
								::memcpy_s(&pVarBuf->vt, 0x40, &vValue.vt, sizeof(vValue.vt));
								::memcpy_s(&V_UINT(pVarBuf), 0x40-0x08, &V_UINT(&vValue), sizeof(V_UINT(&vValue)));
							}
							else
							if(V_VT(&vValue) == VT_DECIMAL)
							{
								::memcpy_s(pVarBuf, 0x40, &vValue, sizeof(VARIANT));
							}
							else
							{
								hr = E_FAIL;
								break;
							}
						}
						else
						{
							break;
						}
					}
				}
			}
		}



		if( SUCCEEDED(hr) )
		{
			hr = MD5((const BYTE*)aBuf, sizeof(aBuf), pKey);
		}



		return hr;
	}
	//--



protected:
    virtual /* [propput][id] */ HRESULT STDMETHODCALLTYPE put_Item( 
        /* [in] */ VARIANT* pKey,
        /* [in] */ VARIANT *pValue)
	{
		if(pKey->vt == VT_BSTR)
		{
			return Set(pKey->bstrVal, pValue);
		}
		else
		{
			return ::RaiseError(E_FAIL, L"memcachedCOM", L"Not supported key type.");
		}
	}
    
    virtual /* [propget][id] */ HRESULT STDMETHODCALLTYPE get_Item( 
        /* [in] */ VARIANT* pKey,
        /* [retval][out] */ VARIANT *pValue)
	{
		if(pKey->vt == VT_BSTR)
		{
			return Get(pKey->bstrVal, pValue);
		}
		else
		if(pKey->vt == VT_DISPATCH)
		{
			pValue->vt = VT_DISPATCH;
			pValue->pdispVal = 0;

			return Execute(ATL::CComQIPtr<ADODB::_Command>(pKey->pdispVal), NULL, 0, &pValue->pdispVal);
		}
		else
		{
			return ::RaiseError(E_FAIL, L"memcachedCOM", L"Not supported key type.");
		}
	}









	virtual HRESULT STDMETHODCALLTYPE Open( 
        /* [in] */ BSTR sIP,
        /* [defaultvalue][in] */ long nPort = 11211)
	{
		HRESULT hr = E_FAIL;



		if(m_oSocket == INVALID_SOCKET)
		{
			m_oSocket = ::socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
			
			sockaddr_in oAddr;
			oAddr.sin_family = AF_INET;
			oAddr.sin_addr.s_addr = ::inet_addr(ATL::CW2A(sIP));
			oAddr.sin_port = ::htons((u_short)nPort);

			if(::connect(m_oSocket, (SOCKADDR*)&oAddr, sizeof(oAddr)) == SOCKET_ERROR)
			{
				m_oSocket = INVALID_SOCKET;

				hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Socket error.");
			}
			else
			{
				hr = S_OK;
			}
		}
		else
		{
			hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Already connected.");
		}



		return hr;
	}

    virtual HRESULT STDMETHODCALLTYPE Close( void)
	{
		HRESULT hr = E_FAIL;



		if(m_oSocket == INVALID_SOCKET)
		{
			hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Not connected.");
		}
		else
		{
			if(::closesocket(m_oSocket) == 0)
			{
				m_oSocket = INVALID_SOCKET;

				hr = S_OK;
			}
			else
			{
				hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Socket error.");
			}
		}



		return hr;
	}

    virtual HRESULT STDMETHODCALLTYPE IsOpen( 
        /* [retval][out] */ VARIANT_BOOL *pOpen)
	{
		*pOpen = (m_oSocket == INVALID_SOCKET) ? VARIANT_FALSE : VARIANT_TRUE;

		return S_OK;
	}
    
    virtual HRESULT STDMETHODCALLTYPE TryOpen( 
        /* [in] */ BSTR sIP,
        /* [defaultvalue][in] */ long nPort,
        /* [retval][out] */ VARIANT_BOOL *pOpened)
	{
		*pOpened = SUCCEEDED( Open(sIP, nPort) ) ? VARIANT_TRUE : VARIANT_FALSE;

		return S_OK;
	}

    virtual HRESULT STDMETHODCALLTYPE TryClose( 
        /* [retval][out] */ VARIANT_BOOL *pClosed)
	{
		*pClosed = SUCCEEDED( Close() ) ? VARIANT_TRUE : VARIANT_FALSE;

		return S_OK;
	}



    virtual HRESULT STDMETHODCALLTYPE Set( 
        /* [in] */ BSTR sKey,
        /* [in] */ VARIANT* pValue,
        /* [defaultvalue][in] */ long nExptime = 0)
	{
		HRESULT hr = E_FAIL;

		if(m_oSocket == INVALID_SOCKET) return ::RaiseError(E_FAIL, L"memcachedCOM", L"Connection is closing.");



		const char*	pValueBuf = 0;
		int			nValueBuf = 0;
		unsigned short	nValueVT = pValue->vt;
		{
			if(nValueVT == VT_BSTR)
			{
				pValueBuf = (const char*)pValue->bstrVal;
				nValueBuf = ::SysStringByteLen(pValue->bstrVal);

				hr = S_OK;
			}
			else
			if(
				nValueVT == VT_EMPTY	||
				nValueVT == VT_NULL		||
				nValueVT == VT_I2		||
				nValueVT == VT_I4		||
				nValueVT == VT_R4		||
				nValueVT == VT_R8		||
				nValueVT == VT_CY		||
				nValueVT == VT_DATE		||
				nValueVT == VT_ERROR	||
				nValueVT == VT_BOOL		||
				nValueVT == VT_DECIMAL	||
				nValueVT == VT_I1		||
				nValueVT == VT_UI1		||
				nValueVT == VT_UI2		||
				nValueVT == VT_UI4		||
				nValueVT == VT_I8		||
				nValueVT == VT_UI8		||
				nValueVT == VT_INT		||
				nValueVT == VT_UINT		||
				false)
			{
				pValueBuf = (const char*)pValue;
				nValueBuf = sizeof(*pValue);

				hr = S_OK;
			}
			else
			{
				hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Not supported value type.");
			}
		}



		if( SUCCEEDED(hr) )
		{
			char	aCmd[0x0200];
			{
				::sprintf_s(aCmd, sizeof(aCmd), "set %s %d %d %d\r\n", ATL::CW2A(sKey).m_psz, nValueVT, nExptime, nValueBuf);
			}

			::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);
			::send(m_oSocket, pValueBuf, nValueBuf, 0);
			::send(m_oSocket, "\r\n", 2, 0);



			char aRes[0x0200];
			{
				int i = 0;
				while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
				{
					if(aRes[i] == '\n')
					{
						++i;
						break;
					}

					++i;
				}
				aRes[i] = '\0';
			}



			hr = (::strcmp(aRes, "STORED\r\n") == 0) ? S_OK : ::RaiseError(E_FAIL, L"memcachedCOM", L"Could not store.");
		}



		return hr;
	}
	//--

    virtual HRESULT STDMETHODCALLTYPE Add( 
        /* [in] */ BSTR sKey,
        /* [in] */ VARIANT *pValue,
        /* [defaultvalue][in] */ long nExptime = 0)
	{
		HRESULT hr = E_FAIL;

		if(m_oSocket == INVALID_SOCKET) return ::RaiseError(E_FAIL, L"memcachedCOM", L"Connection is closing.");



		const char*	pValueBuf = 0;
		int			nValueBuf = 0;
		unsigned short	nValueVT = pValue->vt;
		{
			if(nValueVT == VT_BSTR)
			{
				pValueBuf = (const char*)pValue->bstrVal;
				nValueBuf = ::SysStringByteLen(pValue->bstrVal);

				hr = S_OK;
			}
			else
			if(
				nValueVT == VT_EMPTY	||
				nValueVT == VT_NULL		||
				nValueVT == VT_I2		||
				nValueVT == VT_I4		||
				nValueVT == VT_R4		||
				nValueVT == VT_R8		||
				nValueVT == VT_CY		||
				nValueVT == VT_DATE		||
				nValueVT == VT_ERROR	||
				nValueVT == VT_BOOL		||
				nValueVT == VT_DECIMAL	||
				nValueVT == VT_I1		||
				nValueVT == VT_UI1		||
				nValueVT == VT_UI2		||
				nValueVT == VT_UI4		||
				nValueVT == VT_I8		||
				nValueVT == VT_UI8		||
				nValueVT == VT_INT		||
				nValueVT == VT_UINT		||
				false)
			{
				pValueBuf = (const char*)pValue;
				nValueBuf = sizeof(*pValue);

				hr = S_OK;
			}
			else
			{
				hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Not supported value type.");
			}
		}



		if( SUCCEEDED(hr) )
		{
			char	aCmd[0x0200];
			{
				::sprintf_s(aCmd, sizeof(aCmd), "add %s %d %d %d\r\n", ATL::CW2A(sKey).m_psz, nValueVT, nExptime, nValueBuf);
			}

			::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);
			::send(m_oSocket, pValueBuf, nValueBuf, 0);
			::send(m_oSocket, "\r\n", 2, 0);



			char aRes[0x0200];
			{
				int i = 0;
				while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
				{
					if(aRes[i] == '\n')
					{
						++i;
						break;
					}

					++i;
				}
				aRes[i] = '\0';
			}



			hr = (::strcmp(aRes, "STORED\r\n") == 0) ? S_OK : ::RaiseError(E_FAIL, L"memcachedCOM", L"Could not store.");
		}



		return hr;
	}
	//--
    
    virtual HRESULT STDMETHODCALLTYPE Replace( 
        /* [in] */ BSTR sKey,
        /* [in] */ VARIANT *pValue,
        /* [defaultvalue][in] */ long nExptime = 0)
	{
		HRESULT hr = E_FAIL;

		if(m_oSocket == INVALID_SOCKET) return ::RaiseError(E_FAIL, L"memcachedCOM", L"Connection is closing.");



		const char*	pValueBuf = 0;
		int			nValueBuf = 0;
		unsigned short	nValueVT = pValue->vt;
		{
			if(nValueVT == VT_BSTR)
			{
				pValueBuf = (const char*)pValue->bstrVal;
				nValueBuf = ::SysStringByteLen(pValue->bstrVal);

				hr = S_OK;
			}
			else
			if(
				nValueVT == VT_EMPTY	||
				nValueVT == VT_NULL		||
				nValueVT == VT_I2		||
				nValueVT == VT_I4		||
				nValueVT == VT_R4		||
				nValueVT == VT_R8		||
				nValueVT == VT_CY		||
				nValueVT == VT_DATE		||
				nValueVT == VT_ERROR	||
				nValueVT == VT_BOOL		||
				nValueVT == VT_DECIMAL	||
				nValueVT == VT_I1		||
				nValueVT == VT_UI1		||
				nValueVT == VT_UI2		||
				nValueVT == VT_UI4		||
				nValueVT == VT_I8		||
				nValueVT == VT_UI8		||
				nValueVT == VT_INT		||
				nValueVT == VT_UINT		||
				false)
			{
				pValueBuf = (const char*)pValue;
				nValueBuf = sizeof(*pValue);

				hr = S_OK;
			}
			else
			{
				hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Not supported value type.");
			}
		}



		if( SUCCEEDED(hr) )
		{
			char	aCmd[0x0200];
			{
				::sprintf_s(aCmd, sizeof(aCmd), "replace %s %d %d %d\r\n", ATL::CW2A(sKey).m_psz, nValueVT, nExptime, nValueBuf);
			}

			::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);
			::send(m_oSocket, pValueBuf, nValueBuf, 0);
			::send(m_oSocket, "\r\n", 2, 0);



			char aRes[0x0200];
			{
				int i = 0;
				while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
				{
					if(aRes[i] == '\n')
					{
						++i;
						break;
					}

					++i;
				}
				aRes[i] = '\0';
			}



			hr = (::strcmp(aRes, "STORED\r\n") == 0) ? S_OK : ::RaiseError(E_FAIL, L"memcachedCOM", L"Could not store.");
		}



		return hr;
	}
	//--



    virtual HRESULT STDMETHODCALLTYPE Get( 
        /* [in] */ BSTR sKey,
        /* [retval][out] */ VARIANT *pValue)
	{
		HRESULT hr = E_FAIL;

		if(m_oSocket == INVALID_SOCKET) return ::RaiseError(E_FAIL, L"memcachedCOM", L"Connection is closing.");



		char	aCmd[0x0200];
		{
			::sprintf_s(aCmd, sizeof(aCmd), "get %s\r\n", ATL::CW2A(sKey).m_psz);
		}

		::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);



		char aRes[0x0200];
		// read line
		{
			int i = 0;
			while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
			{
				if(aRes[i] == '\n')
				{
					++i;
					break;
				}

				++i;
			}
			aRes[i] = '\0';
		}

		if( ::strcmp(aRes, "END\r\n") == 0 )
		{
			pValue->vt = VT_EMPTY;

			hr = S_OK;
		}
		else
		{
			// parse
			char aKey[0x100];
			int nFlag = 0;
			int nLen = 0;
			if( ::sscanf_s(aRes, "VALUE %s %d %d\r\n", aKey, sizeof(aKey), &nFlag, &nLen) == 3 )
			{
				if(nFlag == VT_BSTR)
				{
					pValue->vt = VT_BSTR;
					pValue->bstrVal = ::SysAllocStringByteLen(NULL, nLen);

					ULONG nReadRemain = nLen;
					int nRead = 0;
					while( nReadRemain && (nRead = ::recv(m_oSocket, (char*)pValue->bstrVal + (nLen-nReadRemain), nReadRemain, 0)) )
					{
						nReadRemain -= nRead;
					}
				}
				else
				if(nLen == sizeof(VARIANT))
				{
					ULONG nReadRemain = nLen;
					int nRead = 0;
					while( nReadRemain && (nRead = ::recv(m_oSocket, (char*)pValue + (nLen-nReadRemain), nReadRemain, 0)) )
					{
						nReadRemain -= nRead;
					}
				}
				else
				{
					hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Unknown stored flag.");
					goto AExit;
				}

				// \r\n
				char aBuf[2];
				::recv(m_oSocket, aBuf, 2, 0);



				// read line
				{
					int i = 0;
					while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
					{
						if(aRes[i] == '\n')
						{
							++i;
							break;
						}

						++i;
					}
					aRes[i] = '\0';
				}

				if( ::strcmp(aRes, "END\r\n") == 0 )
				{
					hr = S_OK;
				}
				else
				{
					hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Unknown response.");
					goto AExit;
				}
			}
			else
			{
				hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Unknown response.");
				goto AExit;
			}
		}



	AExit:
		return hr;
	}
	//--

    virtual HRESULT STDMETHODCALLTYPE Delete( 
        /* [in] */ BSTR sKey)
	{
		HRESULT hr = E_FAIL;

		if(m_oSocket == INVALID_SOCKET) return ::RaiseError(E_FAIL, L"memcachedCOM", L"Connection is closing.");



		char	aCmd[0x0200];
		{
			::sprintf_s(aCmd, sizeof(aCmd), "delete %s\r\n", ATL::CW2A(sKey).m_psz);
		}

		::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);



		char aRes[0x0200];
		{
			int i = 0;
			while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
			{
				if(aRes[i] == '\n')
				{
					++i;
					break;
				}

				++i;
			}
			aRes[i] = '\0';
		}



		hr = (::strcmp(aRes, "DELETED\r\n") == 0) ? S_OK : ::RaiseError(E_FAIL, L"memcachedCOM", L"Could not delete.");

		return hr;
	}
	//--



    virtual HRESULT STDMETHODCALLTYPE Gets( 
        /* [in] */ BSTR sKey,
        /* [out] */ VARIANT *pCasUnique,
        /* [retval][out] */ VARIANT *pValue)
	{
		HRESULT hr = E_FAIL;

		if(m_oSocket == INVALID_SOCKET) return ::RaiseError(E_FAIL, L"memcachedCOM", L"Connection is closing.");



		char	aCmd[0x0200];
		{
			::sprintf_s(aCmd, sizeof(aCmd), "gets %s\r\n", ATL::CW2A(sKey).m_psz);
		}

		::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);



		char aRes[0x0200];
		// read line
		{
			int i = 0;
			while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
			{
				if(aRes[i] == '\n')
				{
					++i;
					break;
				}

				++i;
			}
			aRes[i] = '\0';
		}

		if( ::strcmp(aRes, "END\r\n") == 0 )
		{
			pValue->vt = VT_EMPTY;

			hr = S_OK;
		}
		else
		{
			// parse
			char aKey[0x100];
			int nFlag = 0;
			int nLen = 0;
			ULONGLONG nCasUnique = 0;
			if( ::sscanf_s(aRes, "VALUE %s %d %d %I64u\r\n", aKey, sizeof(aKey), &nFlag, &nLen, &nCasUnique) == 4 )
			{
				pCasUnique->vt = VT_UI8;
				pCasUnique->ullVal = nCasUnique;



				if(nFlag == VT_BSTR)
				{
					pValue->vt = VT_BSTR;
					pValue->bstrVal = ::SysAllocStringByteLen(NULL, nLen);

					ULONG nReadRemain = nLen;
					int nRead = 0;
					while( nReadRemain && (nRead = ::recv(m_oSocket, (char*)pValue->bstrVal + (nLen-nReadRemain), nReadRemain, 0)) )
					{
						nReadRemain -= nRead;
					}
				}
				else
				if(nLen == sizeof(VARIANT))
				{
					ULONG nReadRemain = nLen;
					int nRead = 0;
					while( nReadRemain && (nRead = ::recv(m_oSocket, (char*)pValue + (nLen-nReadRemain), nReadRemain, 0)) )
					{
						nReadRemain -= nRead;
					}
				}
				else
				{
					hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Unknown stored flag.");
					goto AExit;
				}

				// \r\n
				char aBuf[2];
				::recv(m_oSocket, aBuf, 2, 0);



				// read line
				{
					int i = 0;
					while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
					{
						if(aRes[i] == '\n')
						{
							++i;
							break;
						}

						++i;
					}
					aRes[i] = '\0';
				}

				if( ::strcmp(aRes, "END\r\n") == 0 )
				{
					hr = S_OK;
				}
				else
				{
					hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Unknown response.");
					goto AExit;
				}
			}
			else
			{
				hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Unknown response.");
				goto AExit;
			}
		}



	AExit:
		return hr;
	}
	//--
    
    virtual HRESULT STDMETHODCALLTYPE Cas( 
        /* [in] */ BSTR sKey,
        /* [in] */ VARIANT *pCasUnique,
        /* [in] */ VARIANT *pValue,
        /* [defaultvalue][in] */ long nExptime = 0)
	{
		HRESULT hr = E_FAIL;

		if(m_oSocket == INVALID_SOCKET) return ::RaiseError(E_FAIL, L"memcachedCOM", L"Connection is closing.");



		const char*	pValueBuf = 0;
		int			nValueBuf = 0;
		unsigned short	nValueVT = pValue->vt;
		{
			if(nValueVT == VT_BSTR)
			{
				pValueBuf = (const char*)pValue->bstrVal;
				nValueBuf = ::SysStringByteLen(pValue->bstrVal);

				hr = S_OK;
			}
			else
			if(
				nValueVT == VT_EMPTY	||
				nValueVT == VT_NULL		||
				nValueVT == VT_I2		||
				nValueVT == VT_I4		||
				nValueVT == VT_R4		||
				nValueVT == VT_R8		||
				nValueVT == VT_CY		||
				nValueVT == VT_DATE		||
				nValueVT == VT_ERROR	||
				nValueVT == VT_BOOL		||
				nValueVT == VT_DECIMAL	||
				nValueVT == VT_I1		||
				nValueVT == VT_UI1		||
				nValueVT == VT_UI2		||
				nValueVT == VT_UI4		||
				nValueVT == VT_I8		||
				nValueVT == VT_UI8		||
				nValueVT == VT_INT		||
				nValueVT == VT_UINT		||
				false)
			{
				pValueBuf = (const char*)pValue;
				nValueBuf = sizeof(*pValue);

				hr = S_OK;
			}
			else
			{
				hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Not supported value type.");
			}
		}



		if( SUCCEEDED(hr) )
		{
			char	aCmd[0x0200];
			{
				ULONGLONG nCasUnique = 0;
				if(pCasUnique->vt == VT_UI8)
				{
					nCasUnique = pCasUnique->ullVal;
				}

				::sprintf_s(aCmd, sizeof(aCmd), "cas %s %d %d %d %I64u\r\n", ATL::CW2A(sKey).m_psz, nValueVT, nExptime, nValueBuf, nCasUnique);
			}

			::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);
			::send(m_oSocket, pValueBuf, nValueBuf, 0);
			::send(m_oSocket, "\r\n", 2, 0);



			char aRes[0x0200];
			{
				int i = 0;
				while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
				{
					if(aRes[i] == '\n')
					{
						++i;
						break;
					}

					++i;
				}
				aRes[i] = '\0';
			}



			hr = (::strcmp(aRes, "STORED\r\n") == 0) ? S_OK : ::RaiseError(E_FAIL, L"memcachedCOM", L"Could not store.");
		}



		return hr;
	}
	//--

    virtual HRESULT STDMETHODCALLTYPE Stats( 
        /* [in] */ BSTR sType,
        /* [retval][out] */ VARIANT *pStats)
	{
		HRESULT hr = E_FAIL;

		if(m_oSocket == INVALID_SOCKET) return ::RaiseError(E_FAIL, L"memcachedCOM", L"Connection is closing.");



		ATL::CComPtr<Scripting::IDictionary> ptrDictionary;
		if( FAILED(hr = ptrDictionary.CoCreateInstance(__uuidof(Scripting::Dictionary))) ) return hr;



		char	aCmd[0x0200];
		{
			::sprintf_s(aCmd, sizeof(aCmd), "stats %s\r\n", ATL::CW2A(sType).m_psz);
		}

		::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);



		while(true)
		{
			char aRes[0x0200];
			// read line
			{
				int i = 0;
				while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
				{
					if(aRes[i] == '\n')
					{
						++i;
						break;
					}

					++i;
				}
				aRes[i] = '\0';
			}



			char aName[0x100];
			char aValue[0x100];

			if(::strcmp(aRes, "END\r\n") == 0)
			{
				hr = S_OK;
				break;
			}
			else
			if( ::sscanf_s(aRes, "STAT %s %s\r\n", aName, sizeof(aName), aValue, sizeof(aValue)) == 2 )
			{
				ATL::CComVariant vKey = ATL::CA2W(aName);
				ATL::CComVariant vValue = ATL::CA2W(aValue);

				if( FAILED(hr = ptrDictionary->put_Item(&vKey, &vValue)) ) break;
			}
			else
			{
				hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Unknown response.");
				break;
			}
		}



		if( SUCCEEDED(hr) )
		{
			pStats->vt = VT_DISPATCH;
			pStats->pdispVal = ptrDictionary.Detach();
		}



		return hr;
	}
	//--



    virtual HRESULT STDMETHODCALLTYPE Execute( 
        /* [in] */ IDispatch *pCommand,
        /* [defaultvalue][in] */ BSTR sKey,
        /* [defaultvalue][in] */ long nExptime,
        /* [retval][out] */ IDispatch **ppRecordset)
	{
		HRESULT hr = E_FAIL;

		if(m_oSocket == INVALID_SOCKET) return ::RaiseError(E_FAIL, L"memcachedCOM", L"Connection is closing.");



		// auto key
		if( ::SysStringLen(sKey) == 0 )
		{
			if( FAILED(hr = CalcKey( ATL::CComQIPtr<ADODB::_Command>(pCommand), &sKey )) )
			{
				goto AExit;
			}
		}



		char aCmd[0x0200];
		char aRes[0x0200];



		// send command
		{
			::sprintf_s(aCmd, sizeof(aCmd), "get %s\r\n", ATL::CW2A(sKey).m_psz);
		}

		::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);



		// read line
		{
			int i = 0;
			while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
			{
				if(aRes[i] == '\n')
				{
					++i;
					break;
				}

				++i;
			}
			aRes[i] = '\0';
		}

		if( ::strcmp(aRes, "END\r\n") == 0 )
		{
			ATL::CComPtr<ADODB::_Recordset> ptrRS;
			if( SUCCEEDED(hr = ptrRS.CoCreateInstance(__uuidof(ADODB::Recordset))) )
			{
				ATL::CComVariant vSource(pCommand);
				ATL::CComVariant vNoParam;
				{
					vNoParam.vt = VT_ERROR;
					vNoParam.scode = DISP_E_PARAMNOTFOUND;
				}

				// execute
				if( SUCCEEDED(hr = ptrRS->Open(vSource, vNoParam, ADODB::adOpenUnspecified, ADODB::adLockUnspecified, -1)) )
				{
					m_ssmBuf.str("");	// init buffer
	
					ATL::CComVariant vDestination(this);
					if( SUCCEEDED(hr = ptrRS->Save(vDestination, ADODB::adPersistADTG)) )
					{
						size_t nSize = m_ssmBuf.tellp();

						// send command
						{
							::sprintf_s(aCmd, sizeof(aCmd), "set %s 0 %d %d\r\n", ATL::CW2A(sKey).m_psz, nExptime, nSize);
						}

						::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);
						::send(m_oSocket, m_ssmBuf.str().c_str(), (int)nSize, 0);
						::send(m_oSocket, "\r\n", 2, 0);



						// read line
						{
							int i = 0;
							while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
							{
								if(aRes[i] == '\n')
								{
									++i;
									break;
								}

								++i;
							}
							aRes[i] = '\0';
						}



						if( SUCCEEDED(hr = (::strcmp(aRes, "STORED\r\n") == 0) ? S_OK : ::RaiseError(E_FAIL, L"memcachedCOM", L"Could not store.")) )
						{
							// send command
							{
								::sprintf_s(aCmd, sizeof(aCmd), "get %s\r\n", ATL::CW2A(sKey).m_psz);
							}

							::send(m_oSocket, aCmd, (int)::strlen(aCmd), 0);



							// read line
							{
								int i = 0;
								while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
								{
									if(aRes[i] == '\n')
									{
										++i;
										break;
									}

									++i;
								}
								aRes[i] = '\0';
							}



							hr = S_OK;
						}

					}

					m_ssmBuf.str("");	// release buffer
				}
			}

		}
		else
		{
			hr = S_OK;
		}



		if( SUCCEEDED(hr) )
		{
			// parse
			char aKey[0x100];
			int nFlag = 0;
			int nLen = 0;
			if( ::sscanf_s(aRes, "VALUE %s %d %d\r\n", aKey, sizeof(aKey), &nFlag, &nLen) == 3 )
			{
				ATL::CComPtr<ADODB::_Recordset> ptrRS;
				if( SUCCEEDED(hr = ptrRS.CoCreateInstance(__uuidof(ADODB::Recordset))) )
				{
					ATL::CComVariant vSource(this);
					ATL::CComVariant vNoParam;
					{
						vNoParam.vt = VT_ERROR;
						vNoParam.scode = DISP_E_PARAMNOTFOUND;
					}

					// execute
					if( SUCCEEDED(hr = ptrRS->Open(vSource, vNoParam, ADODB::adOpenUnspecified, ADODB::adLockUnspecified, -1)) )
					{
						*ppRecordset = ptrRS.Detach();



						// \r\n
						char aBuf[2];
						::recv(m_oSocket, aBuf, 2, 0);



						// read line
						{
							int i = 0;
							while(i<sizeof(aRes)-1 && 0<::recv(m_oSocket, aRes+i, 1, 0))
							{
								if(aRes[i] == '\n')
								{
									++i;
									break;
								}

								++i;
							}
							aRes[i] = '\0';
						}

						if( ::strcmp(aRes, "END\r\n") == 0 )
						{
							hr = S_OK;
						}
						else
						{
							hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Unknown response.");
						}
					}
				}
			}
			else
			{
				hr = ::RaiseError(E_FAIL, L"memcachedCOM", L"Unknown response.");
			}

		}



AExit:
		return hr;
	}
	//--



// IStream
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Read( 
        /* [length_is][size_is][out] */ void *pv,
        /* [in] */ ULONG cb,
        /* [out] */ ULONG *pcbRead)
	{
		ULONG nReadRemain = cb;
		int nRead = 0;
		while( nReadRemain && (nRead = ::recv(m_oSocket, (char*)pv + (cb-nReadRemain), nReadRemain, 0)) )
		{
			nReadRemain -= nRead;
		}

		*pcbRead = cb - nReadRemain;

		return S_OK;
	}
    
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Write( 
        /* [size_is][in] */ const void *pv,
        /* [in] */ ULONG cb,
        /* [out] */ ULONG *pcbWritten)
	{
		m_ssmBuf.write((const char*)pv, cb);

		*pcbWritten = cb;

		return S_OK;
	}

    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Seek( 
        /* [in] */ LARGE_INTEGER dlibMove,
        /* [in] */ DWORD dwOrigin,
        /* [out] */ ULARGE_INTEGER *plibNewPosition)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE SetSize( 
        /* [in] */ ULARGE_INTEGER libNewSize)
	{
		return E_NOTIMPL;
	}
    
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE CopyTo( 
        /* [unique][in] */ IStream *pstm,
        /* [in] */ ULARGE_INTEGER cb,
        /* [out] */ ULARGE_INTEGER *pcbRead,
        /* [out] */ ULARGE_INTEGER *pcbWritten)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE Commit( 
        /* [in] */ DWORD grfCommitFlags)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE Revert( void)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE LockRegion( 
        /* [in] */ ULARGE_INTEGER libOffset,
        /* [in] */ ULARGE_INTEGER cb,
        /* [in] */ DWORD dwLockType)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE UnlockRegion( 
        /* [in] */ ULARGE_INTEGER libOffset,
        /* [in] */ ULARGE_INTEGER cb,
        /* [in] */ DWORD dwLockType)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE Stat( 
        /* [out] */ STATSTG *pstatstg,
        /* [in] */ DWORD grfStatFlag)
	{
		return E_NOTIMPL;
	}
    
    virtual HRESULT STDMETHODCALLTYPE Clone( 
        /* [out] */ IStream **ppstm)
	{
		return E_NOTIMPL;
	}



// IUnknown override
	virtual HRESULT STDMETHODCALLTYPE QueryInterface( 
        /* [in] */ REFIID riid,
        /* [iid_is][out] */ void __RPC_FAR *__RPC_FAR *ppvObject)
	{
		if(::IsEqualGUID(IID_IStream, riid))
		{
			*ppvObject = static_cast<IStream*>(this);
		}
		else
		{
			return E_NOINTERFACE;
		}

		static_cast<IUnknown*>(static_cast<IDispatch*>(this))->AddRef();

		return S_OK;
	}

};









HINSTANCE	g_hDLL						= NULL;
wchar_t		g_aDLLPath[MAX_PATH]		= L"";
wchar_t		g_aDLLFolderPath[MAX_PATH]	= L"";

ITypeInfo* g_pTI_ImemcachedCOM	= NULL;



BOOL WINAPI DllMain(
	HINSTANCE hinstDLL,
	DWORD fdwReason,
	LPVOID lpvReserved)
{
	BOOL bReturn = TRUE;

	switch(fdwReason)
	{
	case DLL_PROCESS_ATTACH:
		{
			g_hDLL = hinstDLL;
			::GetModuleFileNameW(g_hDLL, g_aDLLPath, MAX_PATH);
			::GetModuleFileNameW(g_hDLL, g_aDLLFolderPath, MAX_PATH);
			::PathRemoveFileSpecW(g_aDLLFolderPath);



			WSADATA oWSAData;
			::WSAStartup(MAKEWORD(2,2), &oWSAData);



			{
				ITypeLib* pTypeLib = NULL;
				{
					::LoadTypeLib(g_aDLLPath, &pTypeLib);
				}

				bReturn = (
					(pTypeLib)	&&
					(SUCCEEDED(pTypeLib->GetTypeInfoOfGuid(__uuidof(ImemcachedCOM), &g_pTI_ImemcachedCOM)) && g_pTI_ImemcachedCOM)	&&
					true) ? TRUE : FALSE;

				if(pTypeLib) pTypeLib->Release();
			}



		    #if defined(_DEBUG)
	        // [Nop
	        ::_CrtSetDbgFlag(
	              _CRTDBG_ALLOC_MEM_DF
	            | _CRTDBG_LEAK_CHECK_DF
			 );
//			_CrtSetBreakAlloc(46);
			new int(0x12345678);
		    #endif
		}
		break;
	case DLL_PROCESS_DETACH:
		{
			if(g_pTI_ImemcachedCOM) g_pTI_ImemcachedCOM->Release();



			::WSACleanup();
		}
		break;
	}

	return bReturn;
}









HRESULT RegistCOM(const wchar_t* pProgID, const wchar_t* pCLSID, const wchar_t* pThreadingModel)
{
	HRESULT hr = E_FAIL;



	HKEY hPROGID		= NULL;
	HKEY hPROGID_CLSID	= NULL;
	HKEY hCLSID			= NULL;
	HKEY hCLSID_CLSID	= NULL;
	HKEY hCLSID_CLSID_InProcServer32	= NULL;

	DWORD dwDisposition;

	if(
		::RegCreateKeyExW(HKEY_CLASSES_ROOT, pProgID, 0, REG_NONE, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE, NULL, &hPROGID, &dwDisposition)	== ERROR_SUCCESS &&
		::RegCreateKeyExW(hPROGID, L"CLSID", 0, REG_NONE, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE, NULL, &hPROGID_CLSID, &dwDisposition)		== ERROR_SUCCESS &&
		::RegSetValueExW(hPROGID_CLSID, NULL, 0, REG_SZ, (const BYTE *)pCLSID, 38*2)														== ERROR_SUCCESS &&

		::RegOpenKeyExW(HKEY_CLASSES_ROOT, L"CLSID", 0, KEY_READ | KEY_WRITE, &hCLSID)	== ERROR_SUCCESS &&
			::RegCreateKeyExW(hCLSID, pCLSID, 0, REG_NONE, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE, NULL, &hCLSID_CLSID, &dwDisposition)									== ERROR_SUCCESS &&
			::RegSetValueExW(hCLSID_CLSID, NULL, 0, REG_SZ, (const BYTE *)pProgID, (DWORD)::wcslen(pProgID)*2)															== ERROR_SUCCESS &&
			::RegCreateKeyExW(hCLSID_CLSID, L"InProcServer32", 0, REG_NONE, REG_OPTION_NON_VOLATILE, KEY_SET_VALUE, NULL, &hCLSID_CLSID_InProcServer32, &dwDisposition)	== ERROR_SUCCESS &&
			::RegSetValueExW(hCLSID_CLSID_InProcServer32, NULL, 0, REG_SZ, (const BYTE *)g_aDLLPath, (DWORD)::wcslen(g_aDLLPath)*2)										== ERROR_SUCCESS &&
			::RegSetValueExW(hCLSID_CLSID_InProcServer32, L"ThreadingModel", 0, REG_SZ, (const BYTE *)pThreadingModel, (DWORD)::wcslen(pThreadingModel)*2)				== ERROR_SUCCESS &&
		true)
	{
		hr = S_OK;
	}

	if(hPROGID)						::RegCloseKey(hPROGID);
	if(hPROGID_CLSID)				::RegCloseKey(hPROGID_CLSID);
	if(hCLSID)						::RegCloseKey(hCLSID);
	if(hCLSID_CLSID)				::RegCloseKey(hCLSID_CLSID);
	if(hCLSID_CLSID_InProcServer32)	::RegCloseKey(hCLSID_CLSID_InProcServer32);



	return hr;
}

HRESULT UnregistCOM(const wchar_t* pProgID, const wchar_t* pCLSID)
{
	HRESULT hr = E_FAIL;



	HKEY hPROGID		= NULL;
	HKEY hCLSID			= NULL;
	HKEY hCLSID_CLSID	= NULL;

	if(
		::RegOpenKeyExW(HKEY_CLASSES_ROOT, pProgID, 0, KEY_READ | KEY_WRITE, &hPROGID)	== ERROR_SUCCESS &&
		::RegDeleteKeyW(hPROGID, L"CLSID")												== ERROR_SUCCESS &&
		::RegDeleteKeyW(HKEY_CLASSES_ROOT, pProgID)										== ERROR_SUCCESS &&

		::RegOpenKeyExW(HKEY_CLASSES_ROOT, L"CLSID", 0, KEY_READ | KEY_WRITE, &hCLSID)	== ERROR_SUCCESS &&
			::RegOpenKeyExW(hCLSID, pCLSID, 0, KEY_READ | KEY_WRITE, &hCLSID_CLSID)			== ERROR_SUCCESS &&
			::RegDeleteKeyW(hCLSID_CLSID, L"InProcServer32")								== ERROR_SUCCESS &&
			::RegDeleteKeyW(hCLSID, pCLSID)													== ERROR_SUCCESS &&
		true)
	{
		hr = S_OK;
	}

	if(hPROGID)			::RegCloseKey(hPROGID);
	if(hCLSID)			::RegCloseKey(hCLSID);
	if(hCLSID_CLSID)	::RegCloseKey(hCLSID_CLSID);



	return hr;
}



long g_nRefCount = 0;

GClassFactory<GDualImpl<ImemcachedCOM, GImemcachedCOMImpl, g_pTI_ImemcachedCOM, &g_nRefCount>, &g_nRefCount> g_oCF_memcachedCOM;



STDAPI  DllGetClassObject(IN REFCLSID rclsid, IN REFIID riid, OUT LPVOID FAR* ppv)
{
	if(::IsEqualGUID(rclsid, CLSID_NULL))
	{
		wchar_t* pClassName = (wchar_t*)*ppv;

		if(!pClassName || pClassName[0] == L'\0')
		{
			return ((IClassFactory*)&g_oCF_memcachedCOM)->QueryInterface(riid, ppv);
		}
		else
		if(::wcscmp(pClassName, L"memcachedCOM") == 0)
		{
			return ((IClassFactory*)&g_oCF_memcachedCOM)->QueryInterface(riid, ppv);
		}
		else
		{
			return CLASS_E_CLASSNOTAVAILABLE;
		}
	}
	else
	if(::IsEqualGUID(rclsid, CLSID_memcachedCOM))
	{
		return ((IClassFactory*)&g_oCF_memcachedCOM)->QueryInterface(riid, ppv);
	}
	else
	{
		return CLASS_E_CLASSNOTAVAILABLE;
	}

}

STDAPI  DllCanUnloadNow(void)
{
	return g_nRefCount ? S_FALSE : S_OK;
}

STDAPI DllRegisterServer(void)
{
	HRESULT hr = E_FAIL;



	if(
		SUCCEEDED(hr = RegistCOM(L"memcachedCOM",			L"{F51C4B6A-8905-4532-92DF-67D9CC0CC98F}", L"Apartment"))	&&
		true)
	{
		hr = S_OK;
	}



	return hr;
}

STDAPI DllUnregisterServer(void)
{
	HRESULT hr = E_FAIL;



	if(
		SUCCEEDED(hr = UnregistCOM(L"memcachedCOM",			L"{F51C4B6A-8905-4532-92DF-67D9CC0CC98F}"))	&&
		true)
	{
		hr = S_OK;
	}



	return hr;
}








