package some;

import java.util.logging.Logger;

public class TestServiceA {

    private static int INTERVAL = 2000; 
    private static Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);
    private static Service service_;

    public static void start(String[] args) {
	service_ = new Service( args );
	Thread th = new Thread(service_);
	th.start();
	logger.info("TestServiceA: start!!");
    }
    
    public static void stop() {
	service_.stop();
	logger.info("TestServiceA: stop..");
    }


    private static class Service implements Runnable {

	private Boolean isRunning = true;
	private String[] args;

	public Service( String[] args ) {
	    this.args = args;
	}

	public void stop() {
	    isRunning = false;
	}

	public void run() {
	    
	    while ( isRunning ) {

		logger.info("TestServiceA: run!!");
		System.out.println("TestServiceA: System.out");
		System.err.println("TestServiceA: System.err");
		for( String s : args ) {
		    System.out.println("TestServiceA: param[" + s + "]");
		}
		
		try {
		    Thread.sleep(INTERVAL);

		}catch( InterruptedException e ){
		    isRunning = false;

		}
	    }
	}

    }

}