package some;

import java.util.logging.Logger;

public class TestService {

    private static int INTERVAL = 2000; 
    private static Logger logger = Logger.getLogger(Logger.GLOBAL_LOGGER_NAME);
    private static Service service_;

    public static void start() {
	service_ = new Service();
	Thread th = new Thread(service_);
	th.start();
	logger.info("TestService: start!!");
    }
	
    public static void stop() {
	service_.stop();
	logger.info("TestService: stop..");
    }


    private static class Service implements Runnable {

	private Boolean isRunning = true;

	public void stop() {
	    isRunning = false;
	}

	public void run() {
	    
	    while ( isRunning ) {

		logger.info("TestService: run!!");
		System.out.println("TestService: System.out");
		System.err.println("TestService: System.err");
		
		try {
		    Thread.sleep(INTERVAL);

		}catch( InterruptedException e ){
		    isRunning = false;

		}
	    }
	}

    }

}