OPTION EXPLICIT

CONST ISAPI_NAME = "Diston"


If WScript.Arguments.Count < 3 Then
	WScript.Echo "Usage : CScript iis7.vbs [Option...]"
	WScript.Echo ""
	WScript.Echo "Option :"
	WScript.Echo "/T:F      install as ISAPI Filter"
	WScript.Echo "/T:E      install as ISAPI Extension "
	WScript.Echo "/N:""xxxx"" site name"
	WScript.Echo "/P:""xxxx"" Diston dll path (absolute)"
	WScript.Quit(100)
End If


Dim g_sType
Dim g_sName
Dim g_sPath

Dim sArg
For Each sArg In WScript.Arguments

	Dim sOption
	sOption = Left(sArg, 2)

	Select Case sOption
	Case "/T":
		g_sType = Mid(sArg, 4)
	Case "/N":
		g_sName = Mid(sArg, 4)
	Case "/P":
		g_sPath = Mid(sArg, 4)
	End Select

Next

If Not ( False _
	OR g_sType = "F" _
	OR g_sType = "E" _
) Then
	WScript.Echo "Option /T is not correct. it must be /T:F(Filter) or /T:E(Extension).  "
	WScript.Quit(201)
End If

If g_sName = "" Then
	WScript.Echo "Option /N is not specified. it must be /N:""[site name]"".  "
	WScript.Quit(202)
End IF

If g_sPath = "" Then
	WScript.Echo "Option /P is not specified. it must be /P:""[Diston dll path (absolute)]"".  "
	WScript.Quit(203)
End IF



Select Case g_sType
Case "F"
	EnableWEBDAV g_sName
	EnableDistonFilter g_sName, g_sPath
	WScript.Echo "Diston was configured as ISAPI Filter!"
	WScript.Quit(0)
Case "E"
	EnableWEBDAV g_sName
	AddWebSvcExtRestriction ISAPI_NAME, g_sPath
	EnableDistonExtension g_sName, g_sPath
	WScript.Echo "Diston was configured as ISAPI Extension!"
	WScript.Quit(0)
Case Else
	'' impossibile
End Select



Sub EnableWEBDAV( sName )

	'' Add WEBDAV To CGI/ISAPI Restriction
	EnableWebSvcExtRestriction "WebDAV"

	Dim oSection
	Dim oElement
	Dim i

	Dim oManager
	Set oManager = CreateObject("Microsoft.ApplicationHost.WritableAdminManager")
	oManager.CommitPath = "MACHINE/WEBROOT/APPHOST"

	On Error Resume Next
		Set oSection = oManager.GetAdminSection("system.webServer/webdav/authoringRules", "MACHINE/WEBROOT/APPHOST" & "/" & sName)
		If Not Err.Number = 0 Then
			WScript.Echo "Site """ & sName & """ does not exist."
			WScript.Quit(301)
		End If
	On Error Goto 0

	'' Remove All Rules
	Do While CLng(oSection.Collection.Count) > 0
		oSection.Collection.DeleteElement(0)
	Loop

	'' Create New Rule
	Set oElement = oSection.Collection.CreateNewElement("add")
	oElement.Properties.Item("users").Value = "*"
	oElement.Properties.Item("path").Value = "*"
	oElement.Properties.Item("access").Value = "Read, Write, Source"
	oSection.Collection.AddElement(oElement)


	'' Set WebDAV Enabled
	Set oSection = oManager.GetAdminSection("system.webServer/webdav/authoring", "MACHINE/WEBROOT/APPHOST" & "/" & sName)
	oSection.Properties.Item("enabled").Value = True

	oManager.CommitChanges()


End Sub


Sub EnableDistonFilter( sName, sFilterPath )

	Dim i
	Dim oSection
	Dim oElement

	Dim oManager
	Set oManager = CreateObject("Microsoft.ApplicationHost.WritableAdminManager")
	oManager.CommitPath = "MACHINE/WEBROOT/APPHOST"


	'' Remove Extension
	Set oSection = oManager.GetAdminSection("system.webServer/handlers", "MACHINE/WEBROOT/APPHOST" & "/" & sName)

	Dim bExists, nIndex
	bExists = False
	For i = 0 To CLng(oSection.Collection.Count)-1
		Set oElement = oSection.Collection.Item(i)
		If oElement.Properties.Item("name").Value = ISAPI_NAME Then
			nIndex = i
			bExists = True
		End If
	Next

	If bExists Then
		oSection.Collection.DeleteElement(nIndex)
	End If


	'' Remove All Filters
	Set oSection = oManager.GetAdminSection("system.webServer/isapiFilters", "MACHINE/WEBROOT/APPHOST" & "/" & sName)
	Do While CLng(oSection.Collection.Count) > 0
		oSection.Collection.DeleteElement(0)
	Loop

	Set oElement = oSection.Collection.CreateNewElement("filter")
	oElement.Properties.Item("name").Value = ISAPI_NAME
	oElement.Properties.Item("path").Value = sFilterPath
'	oElement.Properties.Item("preCondition").Value = "bitness64"
	oSection.Collection.AddElement(oElement)

	oManager.CommitChanges()

End Sub


Sub EnableDistonExtension( sName, sExtensionPath )

	Dim i
	Dim oSection
	Dim oElement


	Dim oManager
	Set oManager = CreateObject("Microsoft.ApplicationHost.WritableAdminManager")
	oManager.CommitPath = "MACHINE/WEBROOT/APPHOST"


	'' Remove All Filters
	Set oSection = oManager.GetAdminSection("system.webServer/isapiFilters", "MACHINE/WEBROOT/APPHOST" & "/" & sName)
	Do While CLng(oSection.Collection.Count) > 0
		oSection.Collection.DeleteElement(0)
	Loop


	'' Set Extension
	Set oSection = oManager.GetAdminSection("system.webServer/handlers", "MACHINE/WEBROOT/APPHOST" & "/" & sName)

	Dim bExists, nIndex
	bExists = False
	For i = 0 To CLng(oSection.Collection.Count)-1
		Set oElement = oSection.Collection.Item(i)
		If oElement.Properties.Item("name").Value = ISAPI_NAME Then
			nIndex = i
			bExists = True
		End If
	Next

	If bExists Then
		Set oElement = oSection.Collection.Item(nIndex)
		oElement.Properties.Item("path").Value = "*"
		oElement.Properties.Item("verb").Value = "*"
		oElement.Properties.Item("modules").Value = "IsapiModule"
		oElement.Properties.Item("scriptProcessor").Value = sExtensionPath
		oElement.Properties.Item("resourceType").Value = "Unspecified"
		oElement.Properties.Item("requireAccess").Value = "None"
'		oElement.Properties.Item("preCondition").Value = "bitness64"
	Else
		Set oElement = oSection.Collection.CreateNewElement("add")
		oElement.Properties.Item("name").Value = ISAPI_NAME
		oElement.Properties.Item("path").Value = "*"
		oElement.Properties.Item("verb").Value = "*"
		oElement.Properties.Item("modules").Value = "IsapiModule"
		oElement.Properties.Item("scriptProcessor").Value = sExtensionPath
		oElement.Properties.Item("resourceType").Value = "Unspecified"
		oElement.Properties.Item("requireAccess").Value = "None"
'		oElement.Properties.Item("preCondition").Value = "bitness64"
		oSection.Collection.AddElement(oElement)
	End If

	oManager.CommitChanges()


End Sub




Sub EnableWebSvcExtRestriction( sName )

	Dim oElement

	Dim sCommitPath
	sCommitPath = "MACHINE/WEBROOT/APPHOST"

	Dim oManager
	Set oManager = CreateObject("Microsoft.ApplicationHost.WritableAdminManager")
	oManager.CommitPath = sCommitPath

	Dim oSection
	Set oSection = oManager.GetAdminSection("system.webServer/security/isapiCgiRestriction", sCommitPath)

	Dim bExists
	bExists = False
	Dim i
	For i = 0 To CLng(oSection.Collection.Count) -1
		Set oElement = oSection.Collection.Item(i)
		If oElement.Properties.Item("description").Value = sName Then
			oElement.Properties.Item("allowed").Value = True
			bExists = True
		End If
	Next

	If bExists Then
		oManager.CommitChanges()
	End If


End Sub



Sub AddWebSvcExtRestriction( sName, sPath )

	Dim oElement

	Dim sCommitPath
	sCommitPath = "MACHINE/WEBROOT/APPHOST"

	Dim oManager
	Set oManager = CreateObject("Microsoft.ApplicationHost.WritableAdminManager")
	oManager.CommitPath = sCommitPath

	Dim oSection
	Set oSection = oManager.GetAdminSection("system.webServer/security/isapiCgiRestriction", sCommitPath)

	Dim bExists
	bExists = False
	Dim i
	For i = 0 To CLng(oSection.Collection.Count) -1
		Set oElement = oSection.Collection.Item(i)
		If oElement.Properties.Item("description").Value = sName Then
			oElement.Properties.Item("allowed").Value = True
			bExists = True
		End If
	Next

	If Not bExists Then

		Set oElement = oSection.Collection.CreateNewElement("add")
		oElement.Properties.Item("path").Value = sPath
		oElement.Properties.Item("allowed").Value = True
		oElement.Properties.Item("description").Value = sName
		oSection.Collection.AddElement(oElement)

	End If

	oManager.CommitChanges()

End Sub




