OPTION EXPLICIT

CONST ISAPI_NAME = "Diston"


If WScript.Arguments.Count < 3 Then
	WScript.Echo "Usage : CScript iis6.vbs [Option...]"
	WScript.Echo ""
	WScript.Echo "Option :"
	WScript.Echo "/T:F      install as ISAPI Filter"
	WScript.Echo "/T:E      install as ISAPI Extension "
	WScript.Echo "/N:""xxxx"" siteID"
	WScript.Echo "/P:""xxxx"" Diston dll path (absolute)"
	WScript.Quit(100)
End If


Dim g_sType
Dim g_sID
Dim g_sPath

Dim sArg
For Each sArg In WScript.Arguments

	Dim sOption
	sOption = Left(sArg, 2)

	Select Case sOption
	Case "/T":
		g_sType = Mid(sArg, 4)
	Case "/N":
		g_sID   = Mid(sArg, 4)
	Case "/P":
		g_sPath = Mid(sArg, 4)
	End Select

Next

If Not ( False _
	OR g_sType = "F" _
	OR g_sType = "E" _
) Then
	WScript.Echo "Option /T is not correct. it must be /T:F(Filter) or /T:E(Extension).  "
	WScript.Quit(201)
End If

If g_sID = "" Then
	WScript.Echo "Option /N is not specified. it must be /N:""[siteID]"".  "
	WScript.Quit(202)
End IF

If g_sPath = "" Then
	WScript.Echo "Option /P is not specified. it must be /P:""[Diston dll path (absolute)]"".  "
	WScript.Quit(203)
End IF



Select Case g_sType
Case "F"
	EnableWEBDAV g_sID
	EnableDistonFilter g_sID, g_sPath
	WScript.Echo "Diston was configured as ISAPI Filter!"
	WScript.Quit(0)
Case "E"
	EnableWEBDAV g_sID
	AddWebSvcExtRestriction ISAPI_NAME, g_sPath
	EnableDistonExtension g_sID, g_sPath
	WScript.Echo "Diston was configured as ISAPI Extension!"
	WScript.Quit(0)
Case Else
	'' impossibile
End Select



Sub EnableWEBDAV( sID )

	'' Add WEBDAV To CGI/ISAPI Restriction
	EnableWebSvcExtRestriction "WEBDAV"

	Dim oRootDir
	On Error Resume Next
		Set oRootDir = GetObject("IIS://localhost/W3SVC/" & sID & "/Root")
		If Not Err.Number = 0 Then
			WScript.Echo "Site """ & sID & """ does not exist."
			WScript.Quit(301)
		End If
	On Error Goto 0

	oRootDir.Put "AccessFlags", 3
	oRootDir.Put "DirBrowseFlags", 2147483710
	oRootDir.Put "AppFriendlyName", "Default Application"
	oRootDir.Put "AppRoot", "/LM/W3SVC/" & sID & "/Root"
	oRootDir.Put "AppIsolated", 2
	oRootDir.Put "ScriptMaps", Array(".__dummy,C:\WINDOWS\system32\inetsrv\ssinc.dll,5,GET,POST")
'	oRootDir.Put "ScriptMaps", ""

	oRootDir.Setinfo

End Sub



Sub EnableDistonFilter( sID, sFilterPath )

	Dim oSite
	Set oSite = GetObject("IIS://localhost/W3SVC/" & sID )

	On Error Resume Next ''Delete All Filters
		oSite.Delete "IIsFilters", "Filters"
	On Error Goto 0

	'' Create Filters Again
	Dim oFilters
	Set oFilters = oSite.Create("IIsFilters", "Filters")

	Dim oFilter
	Set oFilter = oFilters.Create("IIsFilter", ISAPI_NAME)
	oFilter.Put "FilterPath", sFilterPath
	oFilter.Setinfo

	oFilters.Put "FilterLoadOrder", ISAPI_NAME
	oFilters.Setinfo


End Sub



Sub EnableDistonExtension( sID, sExtensionPath )


	'' Delete All Filters
	Dim oSite
	Set oSite = GetObject("IIS://localhost/W3SVC/" & sID )

	On Error Resume Next
		oSite.Delete "IIsFilters", "Filters"
	On Error Goto 0


	'' Set Script Mapping
	Dim oRootDir
	Set oRootDir = GetObject("IIS://localhost/W3SVC/" & sID & "/Root")
	oRootDir.Put "ScriptMaps", Array("*,""" & sExtensionPath & """,0,All")
	oRootDir.Setinfo


End Sub



Sub EnableWebSvcExtRestriction( sName )

	Dim oService
	Set oService = GetObject("IIS://localhost/W3SVC")

	Dim aRests
	Dim bFlag
	On Error Resume Next
		aRests = oService.Get("WebSvcExtRestrictionList")
		If Err.Number = 0 Then
			bFlag = True
		Else
			bFlag = False
		End If
	On Error Goto 0

	If bFlag Then '' IIS 6.0 Only

		Dim i ,bExists
		bExists = False
		For i = 0 To Ubound(aRests)
			Dim aProps
			aProps = Split(aRests(i), ",")
			If Ubound(aProps) => 3 Then
				If aProps(3) = sName Then
					aProps(0) = "1"
					aRests(i) = Join( aProps, "," )
					bExists = True
				End If
			End If
		Next

		If bExists Then
			oService.Put "WebSvcExtRestrictionList", aRests
			oService.Setinfo
		End If

	End If

End Sub



Sub AddWebSvcExtRestriction( sName, sPath )

	Dim i

	Dim oService
	Set oService = GetObject("IIS://localhost/W3SVC")

	Dim aRests
	Dim bFlag
	On Error Resume Next
		aRests = oService.Get("WebSvcExtRestrictionList")
		If Err.Number = 0 Then
			bFlag = True
		Else
			bFlag = False
		End If
	On Error Goto 0

	If bFlag Then '' IIS 6.0 Only

		Dim bExists
		bExists = False
		For i = 0 To Ubound(aRests)
			Dim aProps
			aProps = Split(aRests(i), ",")
			If Ubound(aProps) => 4 Then
				If aProps(4) = sName Then
					aProps(0) = "1"
					aRests(i) = Join( aProps, "," )
					bExists = True
				End If
			End If
		Next

		If bExists Then
			oService.Put "WebSvcExtRestrictionList", aRests
			oService.Setinfo
		Else

			ReDim aNewRests( Ubound(aRests)+1 )
			For i = 0 To Ubound(aRests)
				aNewRests(i) = aRests(i)
			Next
			aNewRests(Ubound(aRests)+1) = "1," & sPath & ",1,," & sName

			oService.Put "WebSvcExtRestrictionList", aNewRests
			oService.Setinfo

		End If

	End If

End Sub



