--[[

You should attach "cdb" or "ntsd" debugger to
"inetinfo.exe" or "w3wp.exe" process
to try this example.

--]]


function on_init()
	 ndebug("on_init()")
	 return true;
end	 

function on_term()
	 ndebug("on_term()")
	 return true;
end

function on_enqueue( pec )

	 local ec = enqueue_context.new(pec)

	 local method = ec:server_variable("HTTP_METHOD")
	 local url    = ec:server_variable("HTTP_URL")
	 local status = ec:http_status()

	 ndebug("on_enqueue()")
	 ndebug("\tmethod:" .. method )
	 ndebug("\turl:"    .. url    )
	 ndebug("\tstatus:" .. status )

	 if ( url ~= "/favicon.ico" ) then
	      	 local t = {}  
	      	 local data = { method = method, url = url, status = status } 
		 return true, data
	 end	       
end

function on_dequeue( data, seq_num )
	 local id = uuid()
	 ndebug("on_dequeue()")
	 ndebug("\tseq_num:" .. seq_num )
	 ndebug("\tid:"      .. id      )
	 ndebug("\tmeghod:"  .. data["method"] )
	 ndebug("\turl:"     .. data["url"]    )
	 ndebug("\tstatus:"  .. data["status"] )
end