//
//  common.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 2/23/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var TestEntry = {
	kTestEntryBasicAnim		: 0,
	kTestEntryComplexAnim		: 1,
	kTestEntryResizedAnim		: 2,
	kTestEntrySpritesheetAnim	: 3,
	kTestEntryFlipAnim		: 4,
	kTestEntryReplaceAnimSprite	: 5,
	kTestEntryTimeEvent		: 6,
	kTestEntryTouchedAnim		: 7,
	kTestEntryBugFix		: 8,
	
	// keep last
	kTestEntryCnt			: 9
};

var HUDLayerButton = {
	kHUDLayerButtonPre	: 0,
	kHUDLayerButtonNext	: 1,
	kHUDLayerButtonMainmenu	: 2,
	
	// keep last
	kHUDLayerButtonCnt	: 3
};

var HUDLayer = cc.Layer.extend({
	// weak reference
	mButtons: null,
	mTitle: null,
	mListener: null,

	ctor: function(){
		this._super();
		this.mButtons = new Array(HUDLayerButton.kHUDLayerButtonCnt);
	},
	init: function(){
		if (this._super() == false) {
			return false;
		}
		
		var aScreenSize = cc.Director.getInstance().getWinSize();
		var aPadding = 30.0;
		this.mTitle = cc.LabelTTF.create("", "Arial", 48);
		this.mTitle.setAnchorPoint(cc.p(0.5, 1.0));
		this.mTitle.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height - aPadding));
		this.addChild(this.mTitle);
		
		aPadding = 24;
		var anOldFontSize = cc.MenuItemFont.fontSize();
		cc.MenuItemFont.setFontSize(48);
		this.mButtons[HUDLayerButton.kHUDLayerButtonPre] = cc.MenuItemFont.create("Pre", this.onButton, this);
		this.mButtons[HUDLayerButton.kHUDLayerButtonPre].setPosition(cc.p(160, aPadding));
		
		this.mButtons[HUDLayerButton.kHUDLayerButtonNext] = cc.MenuItemFont.create("Next", this.onButton, this);
		this.mButtons[HUDLayerButton.kHUDLayerButtonNext].setPosition(cc.p(aScreenSize.width - 60, aPadding));
		
		this.mButtons[HUDLayerButton.kHUDLayerButtonMainmenu] = cc.MenuItemFont.create("Mainmenu", this.onButton, this);
		this.mButtons[HUDLayerButton.kHUDLayerButtonMainmenu].setPosition(cc.p(aScreenSize.width * 0.5, aPadding));
		
		cc.MenuItemFont.setFontSize(anOldFontSize);
		
		var aMenu = cc.Menu.create(this.mButtons[HUDLayerButton.kHUDLayerButtonPre], this.mButtons[HUDLayerButton.kHUDLayerButtonMainmenu], this.mButtons[HUDLayerButton.kHUDLayerButtonNext], null);
		this.addChild(aMenu);
		aMenu.setPosition(cc.PointZero());
		
		return true;
	},
	onButton: function(theSender){
		var aPressedBtn = HUDLayerButton.kHUDLayerButtonCnt;
		for (var i = 0; i < HUDLayerButton.kHUDLayerButtonCnt; i++) {
			if (theSender === this.mButtons[i]) {
				cc.log("HUD layer: button " + i + " is pressed.");
				aPressedBtn = i;
				break;
			}
		}
		if (aPressedBtn != HUDLayerButton.kHUDLayerButtonCnt &&	this.mListener) {
			this.mListener.onHUDLayerButton(aPressedBtn);
		}
	},
});

var gTestEntryNames = [
	"Basic Animation",
	"Complex Animation",
	"Resized Animation",
	"Use Sprite Sheet",
	"Flip Animatiion",
	"Replace animation sprite",
	"Time Event",
	"Touch Event",
	"Bug Fix"
];

var getTestEntryName = function(theEntry){
	if (theEntry == TestEntry.kTestEntryCnt) {
		cc.assert(false, "error");
		return "";
	}
	return gTestEntryNames[theEntry];
}

var SAM_BASIC = "res/basic_transform/";
var SAM_ATTACK_FRONT = "res/attack_front/";
var SAM_FADEIN_TAP = "res/fadein_tap/";
var SAM_FISH = "res/fish/";
var SAM_FISH_SPRITESHEET = "res/fish_spritesheet/";
var SAM_FISH_50 = "res/fish_50/";
var SAM_FISH_150 = "res/fish_150/";
var SAM_FRAME_BY_FRAME = "res/frame_by_frame/";
var SAM_NO_FLICKER = "res/no-flicker/";
// for rename sprite feature
var SAM_RENAME_NORMAL = "res/rename_sprite/normal/";
var SAM_RENAME_1  = "res/rename_sprite/rename-1/";
var SPRITE_RENAME_1_SWORD_ORIGIN = "res/rename_sprite/rename-1/sword.png";
var SPRITE_RENAME_1_SWORD_NEW = "res/rename_sprite/rename-1/sword_new.png";
var SAM_RENAME_ALL = "res/rename_sprite/rename-all/";
var SPRITE_RENAME_ALL_1_ORIGIN = "res/rename_sprite/rename-all/_1.png";
var SPRITE_RENAME_ALL_2_ORIGIN = "res/rename_sprite/rename-all/_2.png";
var SPRITE_RENAME_ALL_3_ORIGIN = "res/rename_sprite/rename-all/_3.png";
var SPRITE_RENAME_ALL_1_NEW = "res/rename_sprite/rename-all/_1_new.png";
var SPRITE_RENAME_ALL_2_NEW = "res/rename_sprite/rename-all/_2_new.png";
var SPRITE_RENAME_ALL_3_NEW = "res/rename_sprite/rename-all/_3_new.png";
var SAM_RENAME_RESIZE = "res/rename_sprite/rename-resize/";
var SPRITE_RENAME_RESIZE_HAT_HEAD_ORIGIN = "res/rename_sprite/rename-resize/hat_head.png";
var SPRITE_RENAME_RESIZE_HAT_HEAD_NEW = "res/rename_sprite/rename-resize/hat_head_new.png";
var SAM_RENAME_SPRITESHEET = "res/rename_sprite/rename-spritesheet/";
var SPRITE_RENAME_SPRITESHEET_HAT_HEAD_ORIGIN = "res/rename_sprite/rename-spritesheet/hat_head.png";
var SPRITE_RENAME_SPRITESHEET_HAT_HEAD_NEW = "res/rename_sprite/rename-spritesheet/hat_head_new.png";

HUDLayer.create = function(theListener){
	var aHUDLayer = new HUDLayer();
	if (aHUDLayer.init()) {
		aHUDLayer.mListener = theListener;
		return aHUDLayer;
	}
	
	return null;
}









