//
//  TouchedAnimScene.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 2/24/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var TouchedAnimScene = cc.Layer.extend({
	mAnim: null,
	mHUD: null,
	
	ctor: function() {
		this.mAnim = null;
		this.mHUD = null;
	},

	init: function(){
		if (this._super() == false) {
			return false;
		}
	
		var aScreenSize = cc.Director.getInstance().getWinSize();
	
		// bg
		this.addChild(cc.LayerColor.create(cc.c4(128, 128, 128, 255)), -1);
	
		var anAnimFileFullPath = cc.FileUtils.getInstance().fullPathFromRelativePath("res/fish/");
		this.mAnim = SuperAnim.SuperAnimNode.create(anAnimFileFullPath, 0, this);
		this.addChild(this.mAnim);
		this.mAnim.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnim.PlaySection("idle");
	
		var aLabel = cc.LabelTTF.create("Touch in the rect to play next section", "Arial", 24);
		this.addChild(aLabel);
		aLabel.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.35));
	
		this.mHUD = HUDLayer.create(this);
		this.addChild(this.mHUD);
		this.mHUD.mButtons[HUDLayerButton.kHUDLayerButtonPre].setEnabled(false);
		this.mHUD.mButtons[HUDLayerButton.kHUDLayerButtonNext].setEnabled(false);
		this.mHUD.mTitle.setString(getTestEntryName(TestEntry.kTestEntryTouchedAnim));
	
		this.setTouchEnabled(true);
	
		return true;
	},
	
	onEnter: function(){
		this._super();

		cc.Director.getInstance().getTouchDispatcher().addTargetedDelegate(this, 0, true);
	},
	
	onExit: function(){
        cc.Director.getInstance().getTouchDispatcher().removeDelegate(this);
		
		this._super();
	},

	draw: function(){
		this._super();
	
		if (this.mAnim) {
			var size = this.mAnim.getContentSize();
			var anchorPoint = this.mAnim.getAnchorPoint();
            var anchorPointInPoints = cc.p(size.width * anchorPoint.x, size.height * anchorPoint.y);
			var offsetPix = cc.pSub(this.mAnim.getPosition(), anchorPointInPoints);
			
			var vertices = [
				cc.p(offsetPix.x,offsetPix.y), cc.p(offsetPix.x+size.width,offsetPix.y),
				cc.p(offsetPix.x+size.width,offsetPix.y+size.height), cc.p(offsetPix.x,offsetPix.y+size.height)
			];
			cc.drawingUtil.setDrawColor4B(255,255,255,255);
		    cc.drawingUtil.drawPoly(vertices, 4, true, false);
		}
	},

	OnAnimSectionEnd: function(theId, theLabelName){
		if (theLabelName == "idle") {
			this.mAnim.PlaySection("idle");
		}
		if (theLabelName == "active") {
			this.mAnim.PlaySection("idle");
		}
	},

	onHUDLayerButton: function(thePressedBtn){
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonMainmenu) {
			cc.Director.getInstance().replaceScene(MainMenuScene.scene());
		}
	},
	
    onTouchBegan:function (touch, event) {
		var point = this.convertTouchToNodeSpace(touch);

		var size = this.mAnim.getContentSize();
		var anchorPoint = this.mAnim.getAnchorPoint();
        var anchorPointInPoints = cc.p(size.width * anchorPoint.x, size.height * anchorPoint.y);
		var offsetPix = cc.pSub(this.mAnim.getPosition(), anchorPointInPoints);
		
		var rect = new cc.Rect();
		rect.origin = offsetPix;
		rect.size = size;
		
		if(cc.rectContainsPoint(rect,point) ){
			if (this.mAnim.GetCurSectionName() != "active") {
				// play active section of the animation
				this.mAnim.PlaySection("active");
			}
		}
		return true;
    },
});


TouchedAnimScene.scene = function(){
	var aScene = cc.Scene.create();
	var aTouchedAnim = new TouchedAnimScene();
	if (aTouchedAnim.init()) {
		aScene.addChild(aTouchedAnim);
		return aScene;
	}
	return null;
}


