//
//  ResizedAnimScene.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 2/24/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var ResizedAnimScene = cc.Layer.extend({
	mAnims: null,
	mHUD: null,

	ctor: function(){
		this._super();
		this.mAnims = new Array(ResizedAnimScene.AnimNodeId.kAnimNodeCnt);
	},
	init: function(){
		if (this._super() == false) {
			return false;
		}
		
		var aScreenSize = cc.Director.getInstance().getWinSize();
		// bg
		this.addChild(cc.LayerColor.create(cc.c4(128, 128, 128, 255)));
		// normal
		this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNodeNormalFish] = SuperAnim.SuperAnimNode.create(SAM_FISH, ResizedAnimScene.AnimNodeId.kAnimNodeNormalFish, this);
		this.addChild(this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNodeNormalFish]);
		this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNodeNormalFish].setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNodeNormalFish].PlaySection("idle");
		// half
		this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNodeHalfFish] = SuperAnim.SuperAnimNode.create(SAM_FISH_50, ResizedAnimScene.AnimNodeId.kAnimNodeHalfFish, this);
		this.addChild(this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNodeHalfFish]);
		this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNodeHalfFish].setPosition(cc.p(aScreenSize.width * 0.25, aScreenSize.height * 0.5));
		this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNodeHalfFish].PlaySection("idle");
		// 150 percent
		this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNode150Fish] = SuperAnim.SuperAnimNode.create(SAM_FISH_150, ResizedAnimScene.AnimNodeId.kAnimNode150Fish, this);
		this.addChild(this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNode150Fish]);
		this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNode150Fish].setPosition(cc.p(aScreenSize.width * 0.75, aScreenSize.height * 0.5));
		this.mAnims[ResizedAnimScene.AnimNodeId.kAnimNode150Fish].PlaySection("idle");
		
		this.mHUD = HUDLayer.create(this);
		this.addChild(this.mHUD);
		this.mHUD.mButtons[HUDLayerButton.kHUDLayerButtonPre].setEnabled(false);
		this.mHUD.mButtons[HUDLayerButton.kHUDLayerButtonNext].setEnabled(false);
		this.mHUD.mTitle.setString(getTestEntryName(TestEntry.kTestEntryResizedAnim));
		
		return true;
	},
	OnAnimSectionEnd: function(theId, theLabelName){
		if (theLabelName == "idle") {
			this.mAnims[theId].PlaySection("active");
		}
		if (theLabelName == "active") {
			this.mAnims[theId].PlaySection("idle");
		}
	},
	onHUDLayerButton: function(thePressedBtn){
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonMainmenu) {
			cc.Director.getInstance().replaceScene(MainMenuScene.scene());
		}
	},
});

ResizedAnimScene.AnimNodeId = {
	kAnimNodeNormalFish	: 0,
	kAnimNodeHalfFish	: 1,
	kAnimNode150Fish	: 2,
	
	// keep last
	kAnimNodeCnt		: 3
};

ResizedAnimScene.scene = function(){
	var aScene = cc.Scene.create();
	var aResizedAnims = new ResizedAnimScene();
	if (aResizedAnims.init()) {
		aScene.addChild(aResizedAnims);
		return aScene;
	}
	return null;
};








