//
//  ReplaceAnimSpriteScene.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 4/11/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var ReplaceAnimSpriteLayerId = {
	kReplaceAnimSpriteLayerNormal		: 0,
	kReplaceAnimSpriteLayerRename1		: 1,
	kReplaceAnimSpriteLayerRenameAll	: 2,
	kReplaceAnimSpriteLayerRenameResize	: 3,
	kReplaceAnimSpriteLayerRenameSpriteSheet: 4,	
	// keep last
	kReplaceAnimSpriteLayerIdCnt		: 5
};

var ReplaceAnimSpriteScene = cc.Layer.extend({
	// weak reference
	mCurLayer: null,
	mCurLayerID: 0,
	mHUD: null,

	ctor: function(){
		this._super();
		this.mCurLayerID = ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerIdCnt;
	},
	init: function(){
		if (this._super() == false) {
			return false;
		}
		
		// background
		this.addChild(cc.LayerColor.create(cc.c4(128, 128, 128, 255)));
		
		this.mHUD = HUDLayer.create(this);
		this.mHUD.mTitle.setString(getTestEntryName(TestEntry.kTestEntryReplaceAnimSprite));
		this.addChild(this.mHUD, 1);
		
		this.changeLayer(ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerNormal);
		
		return true;
	},
	changeLayer: function(theNewLayer){
		if (this.mCurLayer) {
			this.mCurLayer.removeFromParentAndCleanup(true);
			this.mCurLayer = null;
			this.mCurLayerID = ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerIdCnt;
		}
		if (theNewLayer == ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerNormal) {
			this.mCurLayerID = ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerNormal;
			this.mCurLayer = ReplaceAnimSpriteLayerNormal.create();
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerRename1) {
			this.mCurLayerID = ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerRename1;
			this.mCurLayer = ReplaceAnimSpriteLayerRename1.create();
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerRenameAll) {
			this.mCurLayerID = ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerRenameAll;
			this.mCurLayer = ReplaceAnimSpriteLayerRenameAll.create();
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerRenameResize) {
			this.mCurLayerID = ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerRenameResize;
			this.mCurLayer = ReplaceAnimSpriteLayerRenameResize.create();
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerRenameSpriteSheet) {
			this.mCurLayerID = ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerRenameSpriteSheet;
			//### this.mCurLayer = ReplaceAnimSpriteLayerRenameSprieSheet.create();
			//### this.addChild(this.mCurLayer);
		}
	},
	onHUDLayerButton: function(thePressedBtn){
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonMainmenu) {
			cc.Director.getInstance().replaceScene(MainMenuScene.scene());
		}
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonNext) {
			var aNewLayerId;
			if (this.mCurLayerID + 1 == ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerIdCnt) {
				aNewLayerId = ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerNormal;
			} else {
				aNewLayerId = (this.mCurLayerID + 1);
			}
			this.changeLayer(aNewLayerId);
		}
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonPre) {
			var aNewLayerId;
			if (this.mCurLayerID - 1 < 0) {
				aNewLayerId = (ReplaceAnimSpriteLayerId.kReplaceAnimSpriteLayerIdCnt - 1);
			} else {
				aNewLayerId = (this.mCurLayerID - 1);
			}
			this.changeLayer(aNewLayerId);
		}
	},
});

ReplaceAnimSpriteScene.scene = function(){
	var aScene = cc.Scene.create();
	var aLayer = new ReplaceAnimSpriteScene();
	if (aLayer.init()) {
		aScene.addChild(aLayer);
		return aScene;
	}
	return null;
};



var ReplaceAnimSpriteLayerNormal = cc.Layer.extend({
	mAnimNode: null,

	ctor: function(){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_RENAME_NORMAL, 0, this);
		this.addChild(this.mAnimNode);
		this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnimNode.PlaySection("attack");
		
		var aTip = cc.LabelTTF.create("Without replacing sprite", "Arial", 24);
		this.addChild(aTip);
		aTip.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.25));
	},
	
	onEnter: function(){
		this._super();
		cc.Director.getInstance().getTouchDispatcher().addTargetedDelegate(this, -1, false);
	},
	
	onExit: function(){
		this._super();
		cc.Director.getInstance().getTouchDispatcher().removeDelegate(this);
	},
	
	onTouchBegan: function(pTouch, pEvent){
		// do nothing
		return true;
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		// repeat
		this.mAnimNode.PlaySection("attack");
	},
});

ReplaceAnimSpriteLayerNormal.create = function(){
	var aLayer = new ReplaceAnimSpriteLayerNormal();
	return aLayer;
};



var ReplaceAnimSpriteLayerRename1 = cc.Layer.extend({
	mAnimNode: null,
	mIsOrigin: undefined,

	ctor: function(){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_RENAME_1, 0, this);
		this.addChild(this.mAnimNode);
		this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnimNode.PlaySection("attack");
		this.mIsOrigin = true;
		
		var aTip = cc.LabelTTF.create("Tap the screen to replace anim sprite\nReplace 1 sprite", "Arial", 24);
		this.addChild(aTip);
		aTip.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.25));
	},
	
	onEnter: function(){
		this._super();
		cc.Director.getInstance().getTouchDispatcher().addTargetedDelegate(this, -1, false);
	},
	
	onExit: function(){
		this._super();
		cc.Director.getInstance().getTouchDispatcher().removeDelegate(this);
	},
	
	onTouchBegan: function(pTouch, pEvent){
		if (this.mIsOrigin) {
			this.mIsOrigin = false;
			// replace the anim sprite
			this.mAnimNode.replaceSprite(SPRITE_RENAME_1_SWORD_ORIGIN, SPRITE_RENAME_1_SWORD_NEW);
		} else {
			this.mIsOrigin = true;
			// resume the anim sprite
			this.mAnimNode.resumeSprite(SPRITE_RENAME_1_SWORD_ORIGIN);
		}
		return true;
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		// repeat
		this.mAnimNode.PlaySection("attack");
	},
});

ReplaceAnimSpriteLayerRename1.create = function(){
	var aLayer = new ReplaceAnimSpriteLayerRename1();
	return aLayer;
};



var ReplaceAnimSpriteLayerRenameAll = cc.Layer.extend({
	mAnimNode: null,
	mIsOrigin: undefined,

	ctor: function(){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_RENAME_ALL, 0, this);
		this.addChild(this.mAnimNode);
		this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnimNode.PlaySection("fadein");
		this.mIsOrigin = true;
		
		var aTip = cc.LabelTTF.create("Tap the screen to replace anim sprite\nreplace all sprite", "Arial", 24);
		this.addChild(aTip);
		aTip.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.25));
	},
	
	onEnter: function(){
		this._super();
		cc.Director.getInstance().getTouchDispatcher().addTargetedDelegate(this, -1, false);
	},
	
	onExit: function(){
		this._super();
		cc.Director.getInstance().getTouchDispatcher().removeDelegate(this);
	},
	
	onTouchBegan: function(pTouch, pEvent){
		if (this.mIsOrigin) {
			this.mIsOrigin = false;
			// replace the anim sprite
			this.mAnimNode.replaceSprite(SPRITE_RENAME_ALL_1_ORIGIN, SPRITE_RENAME_ALL_1_NEW);
			this.mAnimNode.replaceSprite(SPRITE_RENAME_ALL_2_ORIGIN, SPRITE_RENAME_ALL_2_NEW);
			this.mAnimNode.replaceSprite(SPRITE_RENAME_ALL_3_ORIGIN, SPRITE_RENAME_ALL_3_NEW);
		} else {
			this.mIsOrigin = true;
			// resume the anim sprite
			this.mAnimNode.resumeSprite(SPRITE_RENAME_ALL_1_ORIGIN);
			this.mAnimNode.resumeSprite(SPRITE_RENAME_ALL_2_ORIGIN);
			this.mAnimNode.resumeSprite(SPRITE_RENAME_ALL_3_ORIGIN);
		}
		return true;
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		// repeat
		if (theLabelName == "fadein") {
			this.mAnimNode.PlaySection("tap");
		}
		if (theLabelName == "tap") {
			this.mAnimNode.PlaySection("fadein");
		}
	},
});

ReplaceAnimSpriteLayerRenameAll.create = function(){
	var aLayer = new ReplaceAnimSpriteLayerRenameAll();
	return aLayer;
};



var ReplaceAnimSpriteLayerRenameResize = cc.Layer.extend({
	mAnimNode: null,
	mIsOrigin: undefined,

	ctor: function(){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_RENAME_RESIZE, 0, this);
		this.addChild(this.mAnimNode);
		this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnimNode.PlaySection("attack");
		this.mIsOrigin = true;
		
		var aTip = cc.LabelTTF.create("Tap the screen to replace anim sprite\nReplace 1 sprite(Resize)", "Arial", 24);
		this.addChild(aTip);
		aTip.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.25));
	},
	
	onEnter: function(){
		this._super();
		cc.Director.getInstance().getTouchDispatcher().addTargetedDelegate(this, -1, false);
	},
	
	onExit: function(){
		this._super();
		cc.Director.getInstance().getTouchDispatcher().removeDelegate(this);
	},
	
	onTouchBegan: function(pTouch, pEvent){
		if (this.mIsOrigin) {
			this.mIsOrigin = false;
			// replace the anim sprite
			this.mAnimNode.replaceSprite(SPRITE_RENAME_RESIZE_HAT_HEAD_ORIGIN, SPRITE_RENAME_RESIZE_HAT_HEAD_NEW);
		} else {
			this.mIsOrigin = true;
			// resume the anim sprite
			this.mAnimNode.resumeSprite(SPRITE_RENAME_RESIZE_HAT_HEAD_ORIGIN);
		}
		return true;
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		// repeat
		this.mAnimNode.PlaySection("attack");
	},
});

ReplaceAnimSpriteLayerRenameResize.create = function(){
	var aLayer = new ReplaceAnimSpriteLayerRenameResize();
	return aLayer;
};



var ReplaceAnimSpriteLayerRenameSprieSheet = cc.Layer.extend({
	mAnimNode: null,
	mIsOrigin: undefined,

	ctor: function(){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_RENAME_SPRITESHEET, 0, this);
		this.addChild(this.mAnimNode);
		this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnimNode.PlaySection("attack");
		this.mIsOrigin = true;
		
		var aTip = cc.LabelTTF.create("Tap the screen to replace anim sprite\nReplace 1 sprite(Sprite Sheet)", "Arial", 24);
		this.addChild(aTip);
		aTip.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.25));
	},
	
	onEnter: function(){
		this._super();
		cc.Director.getInstance().getTouchDispatcher().addTargetedDelegate(this, -1, false);
	},
	
	onExit: function(){
		this._super();
		cc.Director.getInstance().getTouchDispatcher().removeDelegate(this);
	},
	
	onTouchBegan: function(pTouch, pEvent){
		if (this.mIsOrigin) {
			this.mIsOrigin = false;
			// replace the anim sprite
			this.mAnimNode.replaceSprite(SPRITE_RENAME_SPRITESHEET_HAT_HEAD_ORIGIN, SPRITE_RENAME_SPRITESHEET_HAT_HEAD_NEW);
		} else {
			this.mIsOrigin = true;
			// resume the anim sprite
			this.mAnimNode.resumeSprite(SPRITE_RENAME_SPRITESHEET_HAT_HEAD_ORIGIN);
		}
		return true;
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		// repeat
		this.mAnimNode.PlaySection("attack");
	},
});

ReplaceAnimSpriteLayerRenameSprieSheet.create = function(){
	var aLayer = new ReplaceAnimSpriteLayerRenameSprieSheet();
	return aLayer;
};









