//
//  ComplexAnimScene.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 2/24/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var ComplexAnimScene = cc.Layer.extend({
	// weak reference
	mCurLayer: null,
	mCurLayerID: 0,
	mHUD: null,

	ctor: function(){
		this._super();
		this.mCurLayerID = ComplexAnimScene.LayerID.kLayerCnt;
	},
	init: function(){
		if (this._super() == false) {
			return false;
		}
		
		// background
		this.addChild(cc.LayerColor.create(cc.c4(128, 128, 128, 255)));
		
		this.mHUD = HUDLayer.create(this);
		this.mHUD.mTitle.setString(getTestEntryName(TestEntry.kTestEntryComplexAnim));
		this.addChild(this.mHUD, 1);
		
		this.changeLayer(ComplexAnimScene.LayerID.kLayerFishAnim);
		return true;
	},
	changeLayer: function(theNewLayer){
		if (this.mCurLayer) {
			this.mCurLayer.removeFromParentAndCleanup(true);
			this.mCurLayer = null;
			this.mCurLayerID = ComplexAnimScene.LayerID.kLayerCnt;
		}
		if (theNewLayer == ComplexAnimScene.LayerID.kLayerFishAnim) {
			this.mCurLayerID = theNewLayer;
			this.mCurLayer = FishAnimLayer.create();
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == ComplexAnimScene.LayerID.kLayerAttackFront) {
			this.mCurLayerID = theNewLayer;
			this.mCurLayer = AttackAnimLayer.create();
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == ComplexAnimScene.LayerID.kLayerFadeinTap) {
			this.mCurLayerID = theNewLayer;
			this.mCurLayer = FadeinTapAnimLayer.create();
			this.addChild(this.mCurLayer);
		}
	},
	onHUDLayerButton: function(thePressedBtn){
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonMainmenu) {
			cc.Director.getInstance().replaceScene(MainMenuScene.scene());
		}
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonNext) {
			var aNewLayerId;
			if (this.mCurLayerID + 1 == ComplexAnimScene.LayerID.kLayerCnt) {
				aNewLayerId = ComplexAnimScene.LayerID.kLayerFishAnim;
			} else {
				aNewLayerId = (this.mCurLayerID + 1);
			}
			this.changeLayer(aNewLayerId);
		}
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonPre) {
			var aNewLayerId;
			if (this.mCurLayerID - 1 < 0) {
				aNewLayerId = (ComplexAnimScene.LayerID.kLayerCnt - 1);
			} else {
				aNewLayerId = (this.mCurLayerID - 1);
			}
			this.changeLayer(aNewLayerId);
		}
	},
});

ComplexAnimScene.LayerID = {
	kLayerFishAnim		: 0,
	kLayerAttackFront	: 1,
	kLayerFadeinTap		: 2,
	
	// keep last
	kLayerCnt		: 3
};

ComplexAnimScene.scene = function(){
	var aScene = cc.Scene.create();
	var aComplexAnim = new ComplexAnimScene();
	if (aComplexAnim.init()) {
		aScene.addChild(aComplexAnim);
		return aScene;
	}
	return null;
}



var FishAnimLayer = cc.Layer.extend({
	mAnimNode: null,

	ctor: function(){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_FISH, 0, this);
		this.addChild(this.mAnimNode);
		this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnimNode.PlaySection("idle");
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		// loop the animation
		if (theLabelName == "idle") {
			this.mAnimNode.PlaySection("active");
		}
		if (theLabelName == "active") {
			this.mAnimNode.PlaySection("idle");
		}
	},
});

FishAnimLayer.create = function(){
	var aLayer = new FishAnimLayer();
	return aLayer;
};



var AttackAnimLayer = cc.Layer.extend({
	mAnimNode: null,

	ctor: function(){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_ATTACK_FRONT, 0, null);
		this.addChild(this.mAnimNode);
		this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnimNode.PlaySection("attack", true);
	},
});

AttackAnimLayer.create = function(){
	var aLayer = new AttackAnimLayer();
	return aLayer;
}



var FadeinTapAnimLayer = cc.Layer.extend({
	mAnimNode: null,

	ctor: function(){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_FADEIN_TAP, 0, this);
		this.addChild(this.mAnimNode);
		this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnimNode.PlaySection("fadein");
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		// loop the animation
		if (theLabelName == "fadein") {
			this.mAnimNode.PlaySection("tap");
		}
		if (theLabelName == "tap") {
			this.mAnimNode.PlaySection("tap");
		}
	},
});

FadeinTapAnimLayer.create = function(){
	var aLayer = new FadeinTapAnimLayer();
	return aLayer;
}








