//
//  BugFixScene.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 2/24/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var BugFixSceneLayerID = {
	kBugFixSceneLayerAlphaBlend1		: 0,
	kBugFixSceneLayerAlphaBlend2		: 1,
	kBugFixSceneLayerDepth1			: 2,
	kBugFixSceneLayerDepth2			: 3,
	kBugFixSceneLayerSpriteSheetPerformance	: 4,
	//kBugFixSceneLayerFrameByFrame		: x,
	kBugFixSceneLayerVairableSpeed		: 5,
	kBugFixSceneLayerNoFlicker		: 6,
	
	// keep last
	kBugFixSceneLayerCnt			: 7
};

var BugFixScene = cc.Layer.extend({
	// weak reference
	mCurLayer: null,
	mCurLayerID: undefined,
	mHUD: null,

	ctor: function(){
		this._super();
		this.mCurLayerID = BugFixSceneLayerID.kBugFixSceneLayerCnt;
	},
	init: function(){
		if (this._super() == false) {
			return false;
		}
		
		// background
		this.addChild(cc.LayerColor.create(cc.c4(128, 128, 128, 255)));
		
		this.mHUD = HUDLayer.create(this);
		this.mHUD.mTitle.setString(getTestEntryName(TestEntry.kTestEntryBugFix));
		this.addChild(this.mHUD, 1);
		
		this.changeLayer(BugFixSceneLayerID.kBugFixSceneLayerAlphaBlend1);
		return true;
	},
	changeLayer: function(theNewLayer){
		if (this.mCurLayer) {
			this.mCurLayer.removeFromParentAndCleanup(true);
			this.mCurLayer = null;
			this.mCurLayerID = BugFixSceneLayerID.kBugFixSceneLayerCnt;
		}
		if (theNewLayer == BugFixSceneLayerID.kBugFixSceneLayerAlphaBlend1) {
			this.mCurLayerID = theNewLayer;
			this.mCurLayer = AlphaBlendLayer.create(BugFixSceneLayerID.kBugFixSceneLayerAlphaBlend1);
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == BugFixSceneLayerID.kBugFixSceneLayerAlphaBlend2) {
			this.mCurLayerID = theNewLayer;
			this.mCurLayer = AlphaBlendLayer.create(BugFixSceneLayerID.kBugFixSceneLayerAlphaBlend2);
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == BugFixSceneLayerID.kBugFixSceneLayerDepth1) {
			this.mCurLayerID = theNewLayer;
			this.mCurLayer = DepthLayer.create(BugFixSceneLayerID.kBugFixSceneLayerDepth1);
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == BugFixSceneLayerID.kBugFixSceneLayerDepth2) {
			this.mCurLayerID = BugFixSceneLayerID.kBugFixSceneLayerDepth2;
			this.mCurLayer = DepthLayer.create(BugFixSceneLayerID.kBugFixSceneLayerDepth2);
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == BugFixSceneLayerID.kBugFixSceneLayerSpriteSheetPerformance) {
			this.mCurLayerID = BugFixSceneLayerID.kBugFixSceneLayerSpriteSheetPerformance;
			this.mCurLayer = SpriteSheetPerformanceLayer.create();
			this.addChild(this.mCurLayer);
		}
		if (theNewLayer == BugFixSceneLayerID.kBugFixSceneLayerVairableSpeed) {
			this.mCurLayerID = BugFixSceneLayerID.kBugFixSceneLayerVairableSpeed;
			this.mCurLayer = VariableAnimSpeedLayer.create();
			this.addChild(this.mCurLayer);
		}
		
		if (theNewLayer == BugFixSceneLayerID.kBugFixSceneLayerNoFlicker) {
			this.mCurLayerID = BugFixSceneLayerID.kBugFixSceneLayerNoFlicker;
			this.mCurLayer = NoFlickerLayer.create();
			this.addChild(this.mCurLayer);
		}
	},
	onHUDLayerButton: function(thePressedBtn){
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonMainmenu) {
			cc.Director.getInstance().replaceScene(MainMenuScene.scene());
		}
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonNext) {
			var aNewLayerId;
			if (this.mCurLayerID + 1 == BugFixSceneLayerID.kBugFixSceneLayerCnt) {
				aNewLayerId = BugFixSceneLayerID.kBugFixSceneLayerAlphaBlend1;
			} else {
				aNewLayerId = (this.mCurLayerID + 1);
			}
			this.changeLayer(aNewLayerId);
		}
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonPre) {
			var aNewLayerId;
			if (this.mCurLayerID - 1 < 0) {
				aNewLayerId = (BugFixSceneLayerID.kBugFixSceneLayerCnt - 1);
			} else {
				aNewLayerId = (this.mCurLayerID - 1);
			}
			this.changeLayer(aNewLayerId);
		}
	},
});

BugFixScene.scene = function(){
	var aScene = cc.Scene.create();
	var aComplexAnim = new BugFixScene();
	if (aComplexAnim.init()) {
		aScene.addChild(aComplexAnim);
		return aScene;
	}
	return null;
};



var AlphaBlendLayer = cc.Layer.extend({
	mAnimNode: null,

	ctor: function(theLayerID){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_FISH, 0, this);
		this.addChild(this.mAnimNode, 1);
		this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnimNode.PlaySection("idle");
		
		var aSprite = cc.Sprite.create("res/HelloWorld.png");
		if (theLayerID == BugFixSceneLayerID.kBugFixSceneLayerAlphaBlend1) {
			this.addChild(aSprite, 0);
			aSprite.setAnchorPoint(cc.p(1.0, 0.5));
			aSprite.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		} else if (theLayerID == BugFixSceneLayerID.kBugFixSceneLayerAlphaBlend2){
			this.addChild(aSprite, 2);
			aSprite.setAnchorPoint(cc.p(0.0, 0.5));
			aSprite.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));

		}
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		// loop the animation
		if (theLabelName == "idle") {
			this.mAnimNode.PlaySection("active");
		}
		if (theLabelName == "active") {
			this.mAnimNode.PlaySection("idle");
		}
	},
});

AlphaBlendLayer.create = function(theLayerID){
	var aLayer = new AlphaBlendLayer(theLayerID);
	return aLayer;
};



var DepthLayer = cc.Layer.extend({
	mAnimNode: null,
	mLayerId: undefined,

	ctor: function(theLayerID){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		if (theLayerID == BugFixSceneLayerID.kBugFixSceneLayerDepth1) {
			this.mLayerId = BugFixSceneLayerID.kBugFixSceneLayerDepth1;
			this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_ATTACK_FRONT, 0, this);
			this.addChild(this.mAnimNode);
			this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
			this.mAnimNode.PlaySection("attack");
			var aLayer = cc.LabelTTF.create("Beard is OK", "Arial", 24);
			this.addChild(aLayer);
			aLayer.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.35));
		} else if (theLayerID == BugFixSceneLayerID.kBugFixSceneLayerDepth2){
			this.mLayerId = BugFixSceneLayerID.kBugFixSceneLayerDepth2;
			this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_FADEIN_TAP, 0, this);
			this.addChild(this.mAnimNode);
			this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
			this.mAnimNode.PlaySection("fadein");
			var aLayer = cc.LabelTTF.create("Tap animation must be played", "Arial", 24);
			this.addChild(aLayer);
			aLayer.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.35));
		} else {
			cc.Assert(false, "error");
		}
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		if (this.mLayerId == BugFixSceneLayerID.kBugFixSceneLayerDepth1) {
			if (theLabelName == "attack") {
				this.mAnimNode.PlaySection("attack");
			}
		}
		if (this.mLayerId == BugFixSceneLayerID.kBugFixSceneLayerDepth2) {
			if (theLabelName == "fadein") {
				this.mAnimNode.PlaySection("tap");
			}
			if (theLabelName == "tap") {
				this.mAnimNode.PlaySection("fadein");
			}
		}
	},
});

DepthLayer.create = function(theLayerID){
	var aDepthLayer = new DepthLayer(theLayerID);
	return aDepthLayer;
};



var SpriteSheetPerformanceLayer = cc.Layer.extend({
	mAnimNode: null,

	ctor: function(){
		this._super();
		this.mAnimNode = new Array(30);
		var aScreenSize = cc.Director.getInstance().getWinSize();
		for (var i = 0; i < 30; i++) {
			//this.mAnimNode[i] = SuperAnim.SuperAnimNode.create(SAM_FISH_SPRITESHEET, i, this);
			this.mAnimNode[i] = SuperAnim.SuperAnimNode.create(SAM_FISH, i, this);
			this.addChild(this.mAnimNode[i]);
			var aRow = Math.floor(i / 5);
			var aCol = Math.floor(i % 5);
			this.mAnimNode[i].setPosition(cc.p(aScreenSize.width * (0.25 + aCol * 0.1), aScreenSize.height * (0.25 + aRow * 0.1)));
			this.mAnimNode[i].PlaySection("idle");
		}
		
		var aLayer = cc.LabelTTF.create("Please check FPS", "Arial", 48);
		this.addChild(aLayer);
		aLayer.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.15));
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		// loop the animation
		if (theLabelName == "idle") {
			this.mAnimNode[theId].PlaySection("active");
		}
		if (theLabelName == "active") {
			this.mAnimNode[theId].PlaySection("idle");
		}
	},
});

SpriteSheetPerformanceLayer.create = function(){
	var aLayer = new SpriteSheetPerformanceLayer();
	return aLayer;
};



var VariableAnimSpeedLayer = cc.Layer.extend({
	mAnimNode: null,

	ctor: function(){
		this._super();
		this.mAnimNode = new Array(3);
		var aScreenSize = cc.Director.getInstance().getWinSize();
		for (var i = 0; i < 3; i++) {
			//this.mAnimNode[i] = SuperAnim.SuperAnimNode.create(SAM_FISH_SPRITESHEET, i, this);
			this.mAnimNode[i] = SuperAnim.SuperAnimNode.create(SAM_FISH, i, this);
			this.addChild(this.mAnimNode[i]);
			this.mAnimNode[i].setPosition(cc.p(aScreenSize.width * (0.25 + i * 0.2), aScreenSize.height * (0.45)));
			this.mAnimNode[i].PlaySection("idle");
			this.mAnimNode[i].setSpeedFactor(0.5 * (i + 1));
		}
		
		var aLayer = cc.LabelTTF.create("Speed factor: 0.5", "Arial", 24);
		this.addChild(aLayer);
		aLayer.setPosition(cc.p(aScreenSize.width * 0.25, aScreenSize.height * 0.35));
		aLayer = cc.LabelTTF.create("Speed factor: 1.0", "Arial", 24);
		this.addChild(aLayer);
		aLayer.setPosition(cc.p(aScreenSize.width * 0.45, aScreenSize.height * 0.35));
		aLayer = cc.LabelTTF.create("Speed factor: 1.5", "Arial", 24);
		this.addChild(aLayer);
		aLayer.setPosition(cc.p(aScreenSize.width * 0.65, aScreenSize.height * 0.35));
	},
	
	OnAnimSectionEnd: function(theId, theLabelName){
		// loop the animation
		if (theLabelName == "idle") {
			this.mAnimNode[theId].PlaySection("active");
		}
		if (theLabelName == "active") {
			this.mAnimNode[theId].PlaySection("idle");
		}
	},
});

VariableAnimSpeedLayer.create = function(){
	var aLayer = new VariableAnimSpeedLayer();
	return aLayer;
}



var NoFlickerLayer = cc.Layer.extend({
	gSectionNames: [
		"right_go",
		"left_go",
		"right_attack",
		"left_attack",
		"right_attack02",
		"left_attack02",
		"right_doubleattack",
		"left_doubleattack",
		"right_die",
		"left_die",
		"right_idle",
		"left_idle",
	],
	
	mAnimNode: null,
	mCurSection: undefined,
	mLabelCurSection: null,

	ctor: function(){
		this._super();
		var aScreenSize = cc.Director.getInstance().getWinSize();
		this.mAnimNode = SuperAnim.SuperAnimNode.create(SAM_NO_FLICKER, 0, this);
		this.addChild(this.mAnimNode);
		this.mAnimNode.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mCurSection = NoFlickerLayer.Section.kSectionRightGo;
		this.mAnimNode.PlaySection(this.gSectionNames[this.mCurSection]);
		
		this.mLabelCurSection = cc.LabelTTF.create(this.gSectionNames[this.mCurSection], "Arial", 24);
		this.addChild(this.mLabelCurSection);
		this.mLabelCurSection.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.85));
		var aLabelTip = cc.LabelTTF.create("Tap the screen to play next section.\n no section flicker.", "Arial", 24);
		this.addChild(aLabelTip);
		aLabelTip.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.25));
		
		cc.Director.getInstance().getTouchDispatcher().addTargetedDelegate(this, -1, false);
	},
	onTouchBegan: function(pTouch, pEvent){
		this.mCurSection = ((this.mCurSection + 1) % NoFlickerLayer.Section.kSectionCnt);
		this.mAnimNode.PlaySection(this.gSectionNames[this.mCurSection]);
		this.mLabelCurSection.setString(this.gSectionNames[this.mCurSection]);
		return true;
	},
	OnAnimSectionEnd: function(theId, theLabelName){
		this.mAnimNode.PlaySection(this.gSectionNames[this.mCurSection]);
	},
});

NoFlickerLayer.Section = {
	kSectionRightGo			: 0,
	kSectionLeftGo			: 1,
	kSectionRightAttack		: 2,
	kSectionLeftAttack		: 3,
	kSectionRightAttack02		: 4,
	kSectionLeftAttack02		: 5,
	kSectionRightDoubleAttack	: 6,
	kSectionLeftDoubleAttack	: 7,
	kSectionRightDie		: 8,
	kSectionLeftDie			: 9,
	kSectionRightIdle		: 10,
	kSectionLeftIdle		: 11,
	
	// keep last
	kSectionCnt			: 12
};

NoFlickerLayer.create = function(){
	var aLayer = new NoFlickerLayer();
	return aLayer;
};









