//
//  BasicAnimScene.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 2/24/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var BasicAnimScene = cc.Layer.extend({
	mHUDLayer: null,
	mAnim: null,

	ctor: function(){
	},
	init: function(){
		if (this._super() == false) {
			return false;
		}
		
		var aScreenSize = cc.Director.getInstance().getWinSize();
		
		this.mAnim = SuperAnim.SuperAnimNode.create(SAM_BASIC, 0, this);
		this.addChild(this.mAnim);
		this.mAnim.setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height * 0.5));
		this.mAnim.PlaySection("fade");
		
		this.mHUDLayer = HUDLayer.create(this);
		this.addChild(this.mHUDLayer);
		this.mHUDLayer.mButtons[HUDLayerButton.kHUDLayerButtonPre].setEnabled(false);
		this.mHUDLayer.mButtons[HUDLayerButton.kHUDLayerButtonNext].setEnabled(false);
		this.mHUDLayer.mTitle.setString(getTestEntryName(HUDLayerButton.kTestEntryBasicAnim));
		return true;
	},
	onHUDLayerButton: function(thePressedBtn){
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonMainmenu) {
			cc.Director.getInstance().replaceScene(MainMenuScene.scene());
		}
	},
	OnAnimSectionEnd: function(theId, theLabelName){
		// loop the animation
		if (theLabelName == "fade") {
			this.mAnim.PlaySection("mixed");
		}
		if (theLabelName == "mixed") {
			this.mAnim.PlaySection("fade");
		}
	},
});

BasicAnimScene.scene = function(){
	var aScene = cc.Scene.create();
	var aBasicAnim = new BasicAnimScene();
	if (aBasicAnim.init()) {
		aScene.addChild(aBasicAnim);
		return aScene;
	}
	return null;
};









