//
//	SuperAnimCommon.js
//
//  Created by Raymond Lu(Raymondlu1105@qq.com)
//  Created by Natural Style Co. Ltd.(window@na-s.jp)
//  
//  All rights reserved.
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//  
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//  
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//  THE SOFTWARE.
//
var SuperAnim = SuperAnim = SuperAnim || {};



SuperAnim.SuperAnimMatrix3 = cc.Class.extend({
	m: null,

	ctor: function(){
		this.m = [[0.0,0.0,0.0],[0.0,0.0,0.0],[0.0,0.0,0.0]];
	},
	LoadIdentity: function(){
		this.m[0][1] = 0.0;
		this.m[0][2] = 0.0;
		this.m[1][0] = 0.0;
		this.m[1][2] = 0.0;
		this.m[2][0] = 0.0;
		this.m[2][1] = 0.0;
		
		this.m[0][0] = 1.0;
		this.m[1][1] = 1.0;
		this.m[2][2] = 1.0;
	},
	op_ast: function(theMat){
		var aResult = new SuperAnim.SuperAnimMatrix3();
		aResult.m[0][0] = this.m[0][0]*theMat.m[0][0] + this.m[0][1]*theMat.m[1][0] + this.m[0][2]*theMat.m[2][0];
		aResult.m[0][1] = this.m[0][0]*theMat.m[0][1] + this.m[0][1]*theMat.m[1][1] + this.m[0][2]*theMat.m[2][1];
		aResult.m[0][2] = this.m[0][0]*theMat.m[0][2] + this.m[0][1]*theMat.m[1][2] + this.m[0][2]*theMat.m[2][2];
		aResult.m[1][0] = this.m[1][0]*theMat.m[0][0] + this.m[1][1]*theMat.m[1][0] + this.m[1][2]*theMat.m[2][0];
		aResult.m[1][1] = this.m[1][0]*theMat.m[0][1] + this.m[1][1]*theMat.m[1][1] + this.m[1][2]*theMat.m[2][1];
		aResult.m[1][2] = this.m[1][0]*theMat.m[0][2] + this.m[1][1]*theMat.m[1][2] + this.m[1][2]*theMat.m[2][2];
		aResult.m[2][0] = this.m[2][0]*theMat.m[0][0] + this.m[2][1]*theMat.m[1][0] + this.m[2][2]*theMat.m[2][0];
		aResult.m[2][1] = this.m[2][0]*theMat.m[0][1] + this.m[2][1]*theMat.m[1][1] + this.m[2][2]*theMat.m[2][1];
		aResult.m[2][2] = this.m[2][0]*theMat.m[0][2] + this.m[2][1]*theMat.m[1][2] + this.m[2][2]*theMat.m[2][2];
		return aResult;
	},
	op_astV: function(theVec){
		return cc.vertex3(	
					   this.m[0][0]*theVec.x + this.m[0][1]*theVec.y + this.m[0][2],
					   this.m[1][0]*theVec.x + this.m[1][1]*theVec.y + this.m[1][2],
					   theVec.z);
	},
	op_astQ: function(theQuad){
		var aNewQuad = theQuad;
		aNewQuad.bl.vertices = this.op_astV(theQuad.bl.vertices);
		aNewQuad.br.vertices = this.op_astV(theQuad.br.vertices);
		aNewQuad.tl.vertices = this.op_astV(theQuad.tl.vertices);
		aNewQuad.tr.vertices = this.op_astV(theQuad.tr.vertices);
		return aNewQuad;
	},
});

SuperAnim.SuperAnimTransform = cc.Class.extend({
	mMatrix: null,

	ctor: function(){
		this.mMatrix = new SuperAnim.SuperAnimMatrix3();
		this.mMatrix.LoadIdentity();
	},
	Scale: function(sx, sy){
		this.mMatrix.m[0][0] *= sx;
		this.mMatrix.m[0][1] *= sx;
		this.mMatrix.m[0][2] *= sx;
		this.mMatrix.m[1][0] *= sy;
		this.mMatrix.m[1][1] *= sy;
		this.mMatrix.m[1][2] *= sy;
	},
	TransformSrc: function(theSrcTransform){
		var aNewTransform = new SuperAnim.SuperAnimTransform();
		aNewTransform.mMatrix.m[0][0] = this.mMatrix.m[0][0]*theSrcTransform.mMatrix.m[0][0] + this.mMatrix.m[0][1]*theSrcTransform.mMatrix.m[1][0];
		aNewTransform.mMatrix.m[0][1] = this.mMatrix.m[0][0]*theSrcTransform.mMatrix.m[0][1] + this.mMatrix.m[0][1]*theSrcTransform.mMatrix.m[1][1];
		aNewTransform.mMatrix.m[1][0] = this.mMatrix.m[1][0]*theSrcTransform.mMatrix.m[0][0] + this.mMatrix.m[1][1]*theSrcTransform.mMatrix.m[1][0];
		aNewTransform.mMatrix.m[1][1] = this.mMatrix.m[1][0]*theSrcTransform.mMatrix.m[0][1] + this.mMatrix.m[1][1]*theSrcTransform.mMatrix.m[1][1];
		aNewTransform.mMatrix.m[0][2] = this.mMatrix.m[0][2] + this.mMatrix.m[0][0]*theSrcTransform.mMatrix.m[0][2] + this.mMatrix.m[0][1]*theSrcTransform.mMatrix.m[1][2];
		aNewTransform.mMatrix.m[1][2] = this.mMatrix.m[1][2] + this.mMatrix.m[1][0]*theSrcTransform.mMatrix.m[0][2] + this.mMatrix.m[1][1]*theSrcTransform.mMatrix.m[1][2];
		return aNewTransform;
	},
	InterpolateTo: function(theNextTransform, thePct){
		var aNewTransform = new SuperAnim.SuperAnimTransform();
		aNewTransform.mMatrix.m[0][0] = (this.mMatrix.m[0][0] * (1.0 - thePct)) + (theNextTransform.mMatrix.m[0][0] * thePct);
		aNewTransform.mMatrix.m[0][1] = (this.mMatrix.m[0][1] * (1.0 - thePct)) + (theNextTransform.mMatrix.m[0][1] * thePct);
		aNewTransform.mMatrix.m[1][0] = (this.mMatrix.m[1][0] * (1.0 - thePct)) + (theNextTransform.mMatrix.m[1][0] * thePct);
		aNewTransform.mMatrix.m[1][1] = (this.mMatrix.m[1][1] * (1.0 - thePct)) + (theNextTransform.mMatrix.m[1][1] * thePct);
		aNewTransform.mMatrix.m[0][2] = (this.mMatrix.m[0][2] * (1.0 - thePct)) + (theNextTransform.mMatrix.m[0][2] * thePct);
		aNewTransform.mMatrix.m[1][2] = (this.mMatrix.m[1][2] * (1.0 - thePct)) + (theNextTransform.mMatrix.m[1][2] * thePct);
		return aNewTransform;
	},
});

SuperAnim.Color = cc.Class.extend({
	mRed: 0,
	mGreen: 0,
	mBlue: 0,
	mAlpha: 255,

	ctor: function(theRed, theGreen, theBlue, theAlpha){
		this.mRed = theRed;
		this.mGreen = theGreen;
		this.mBlue = theBlue;
		this.mAlpha = theAlpha;
	},
	InterpolateTo: function(theNextColor, thePct){
		return new SuperAnim.Color(
				 Math.floor(this.mRed * (1.0 - thePct) + theNextColor.mRed * thePct),
				 Math.floor(this.mGreen * (1.0 - thePct) + theNextColor.mGreen * thePct),
				 Math.floor(this.mBlue * (1.0 - thePct) + theNextColor.mBlue * thePct),
				 Math.floor(this.mAlpha * (1.0 - thePct) + theNextColor.mAlpha * thePct)
				);
	},
});



SuperAnim.InvalidSuperAnimSpriteId = 0;

SuperAnim.SuperAnimHandler = cc.Class.extend({
	mMainDefKey: '',
	mCurLabel: '',
	mFirstFrameNumOfCurLabel: 0,
	mLastFrameNumOfCurLabel: 0,
	mCurFrameNum: 0.0,
	mAnimRate: 0.0,
	mWidth: 0.0,
	mHeight: 0.0,
	mIsHandlerValid: false,
	
	ctor: function(){
	},
	IsValid: function(){
		return this.mIsHandlerValid;
	},
});

SuperAnim.SuperAnimObjDrawInfo = cc.Class.extend({
	mSpriteId: SuperAnim.InvalidSuperAnimSpriteId,
	mTransform: null,
	mColor: null,
	
	ctor: function(){
		this.mTransform = new SuperAnim.SuperAnimTransform();
		this.mColor = new SuperAnim.Color();
	}
});
	





