//
//  TimeEventScene.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 2/24/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var AnimId = {};
AnimId.kAnimAttacker		= 0;
AnimId.kAnimAttacked		= 1;
AnimId.kAnimIdCnt			= 2;

var TimeEventId = {};
TimeEventId.kTimeEventHit	= 0;
TimeEventId.kTiemEventIdCnt	= 1;

var ButtonId = {};
ButtonId.kButtonAddTimeEvent	= 0;
ButtonId.kButtonRemoveTimeEvent	= 1;
ButtonId.kButtonIdCnt			= 2;

var PhaseId = {};
PhaseId.kPhaseIdle				= 0;
PhaseId.kPhaseAddedTimeEvent	= 1;
PhaseId.kPhaseRemovedTimeEvent	= 2;
PhaseId.kPhaseCnt				= 3;

var TimeEventSceneLayerID = {};
TimeEventSceneLayerID.kTimeEventSceneLayerAttackToDie = 0,
// keep last
TimeEventSceneLayerID.kTimeEventSceneLayerCnt = 1;


var TimeEventAttackToDieLayer = cc.Layer.extend({
	
	mAnimNode: new Array(),
	mButtons: new Array(),
	mPhase: PhaseId.kPhaseIdle,
	
	ctor: function() {
		this._super();
		
		var aScreenSize = cc.Director.getInstance().getWinSize();
		var anAnimFileFullPath = cc.FileUtils.getInstance().fullPathFromRelativePath("res/no-flicker/");
		
		this.mAnimNode[AnimId.kAnimAttacker] = SuperAnim.SuperAnimNode.create(anAnimFileFullPath, AnimId.kAnimAttacker, this);
		this.addChild(this.mAnimNode[AnimId.kAnimAttacker]);
		this.mAnimNode[AnimId.kAnimAttacker].setPosition(cc.p(aScreenSize.width * 0.35, aScreenSize.height * 0.5));
		this.mAnimNode[AnimId.kAnimAttacker].PlaySection("right_idle");
		
		this.mAnimNode[AnimId.kAnimAttacked] = SuperAnim.SuperAnimNode.create(anAnimFileFullPath, AnimId.kAnimAttacked, this);
		this.addChild(this.mAnimNode[AnimId.kAnimAttacked]);
		this.mAnimNode[AnimId.kAnimAttacked].setPosition(cc.p(aScreenSize.width * 0.75, aScreenSize.height * 0.5));
		this.mAnimNode[AnimId.kAnimAttacked].PlaySection("left_idle");
		
		this.mPhase = PhaseId.kPhaseIdle;
		
		
		this.mButtons[ButtonId.kButtonAddTimeEvent] = cc.MenuItemFont.create("Add Attack Time Event", this.onButton, this);
		this.mButtons[ButtonId.kButtonAddTimeEvent].setPosition(cc.p(aScreenSize.width * 0.25, aScreenSize.height * 0.35));
		
		this.mButtons[ButtonId.kButtonRemoveTimeEvent] = cc.MenuItemFont.create("Remove Attack Time Event", this.onButton, this);
		this.mButtons[ButtonId.kButtonRemoveTimeEvent].setPosition(cc.p(aScreenSize.width * 0.75, aScreenSize.height * 0.35));
		
		var aMenu = cc.Menu.create();
		for (var i = 0; i < ButtonId.kButtonIdCnt; i++) {
			aMenu.addChild(this.mButtons[i]);
		}
		this.addChild(aMenu);
		aMenu.setPosition(cc.PointZero);
	
		this.changeUI();
	},
	
	onEnter: function() {
		this._super();
		cc.Director.getInstance().getTouchDispatcher().addTargetedDelegate(this, -1, false);
	},
	
	onExit: function() {
		this._super();
		cc.Director.getInstance().getTouchDispatcher().removeDelegate(this);
	},
	
	OnAnimSectionEnd: function(theId, theLabelName) {
		if (theId == AnimId.kAnimAttacker) {
			// loop
			this.mAnimNode[AnimId.kAnimAttacker].PlaySection(theLabelName);
		}
		
		if (theId == AnimId.kAnimAttacked) {
			if (theLabelName == "left_die") {
				// goto idle
				this.mAnimNode[AnimId.kAnimAttacked].PlaySection("left_idle");
			} else {
				// loop
				this.mAnimNode[AnimId.kAnimAttacked].PlaySection(theLabelName);
			}
		}
	},
	
	OnTimeEvent: function(theId, theLabelName, theEventId){
		if (theId == AnimId.kAnimAttacker && theEventId == TimeEventId.kTimeEventHit) {
			// time to play die aniamtion for the attacked
			this.mAnimNode[AnimId.kAnimAttacked].PlaySection("left_die");
		}
	},
	
	ccTouchBegan: function(pTouch, pEvent) {

		return true;
	},
	
	changeUI: function() {
		if (this.mPhase == PhaseId.kPhaseIdle ||
			this.mPhase == PhaseId.kPhaseRemovedTimeEvent) {
			this.mButtons[ButtonId.kButtonRemoveTimeEvent].setEnabled(false);
			this.mButtons[ButtonId.kButtonAddTimeEvent].setEnabled(true);
		} else {
			this.mButtons[ButtonId.kButtonRemoveTimeEvent].setEnabled(true);
			this.mButtons[ButtonId.kButtonAddTimeEvent].setEnabled(false);
		}
	},
	
	onButton: function(theSender){
		if (theSender == this.mButtons[ButtonId.kButtonAddTimeEvent]) {
			this.mAnimNode[AnimId.kAnimAttacker].registerTimeEvent("right_doubleattack", 0.9, TimeEventId.kTimeEventHit);
			this.mAnimNode[AnimId.kAnimAttacker].PlaySection("right_doubleattack");
			this.mPhase = PhaseId.kPhaseAddedTimeEvent;
		}
		if (theSender == this.mButtons[ButtonId.kButtonRemoveTimeEvent]) {
			this.mAnimNode[AnimId.kAnimAttacker].removeTimeEvent("right_doubleattack", TimeEventId.kTimeEventHit);
			this.mAnimNode[AnimId.kAnimAttacker].PlaySection("right_idle");
			this.mPhase = PhaseId.kPhaseRemovedTimeEvent;
		}
		
		this.changeUI();
	},
});

TimeEventAttackToDieLayer.create = function() {
	var aLayer = new TimeEventAttackToDieLayer();
	return aLayer;
}





var TimeEventScene = cc.Layer.extend({
	mCurLayer: null,
	mCurLayerID: TimeEventSceneLayerID.kTimeEventSceneLayerCnt,
	mHUD: null,
	
	ctor: function() {
		this.mCurLayer = null;
		this.mCurLayerID = TimeEventSceneLayerID.kTimeEventSceneLayerCnt;
		this.mHUD = null;
	},
	
	init: function() {
		if (this._super() == false) {
			return false;
		}
	
		// background
		this.addChild(cc.LayerColor.create(cc.c4(255, 128, 128, 255)));
	
		this.mHUD = HUDLayer.create(this);
		this.mHUD.mTitle.setString(getTestEntryName(TestEntry.kTestEntryTimeEvent));
		this.addChild(this.mHUD, 1);
	
		this.changeLayer(TimeEventSceneLayerID.kTimeEventSceneLayerAttackToDie);
		return true;
	},
	
	changeLayer: function(theNewLayer){
		if (this.mCurLayer) {
			this.mCurLayer.removeFromParentAndCleanup(true);
			this.mCurLayer = null;
			this.mCurLayerID = TimeEventSceneLayerID.kTimeEventSceneLayerCnt;
		}

		 if (theNewLayer == TimeEventSceneLayerID.kTimeEventSceneLayerAttackToDie) {
			 this.mCurLayerID = TimeEventSceneLayerID.kTimeEventSceneLayerAttackToDie;
			 this.mCurLayer = TimeEventAttackToDieLayer.create();
			 this.addChild(this.mCurLayer);
		 }
	},
	
	onHUDLayerButton: function(thePressedBtn) {
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonMainmenu) {
			cc.Director.getInstance().replaceScene(MainMenuScene.scene());
		}
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonNext) {
			var aNewLayerId;
			if (this.mCurLayerID + 1 == TimeEventSceneLayerID.kTimeEventSceneLayerCnt) {
				aNewLayerId = TimeEventSceneLayerID.kTimeEventSceneLayerAttackToDie;
			} else {
				aNewLayerId = (TimeEventSceneLayerID)(mCurLayerID + 1);
			}
			this.changeLayer(aNewLayerId);
		}
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonPre) {
			var aNewLayerId;
			if (this.mCurLayerID - 1 < 0) {
				aNewLayerId = TimeEventSceneLayerID.kTimeEventSceneLayerCnt - 1;
			} else {
				aNewLayerId = this.mCurLayerID - 1;
			}
			this.changeLayer(aNewLayerId);
		}
	}
});


TimeEventScene.scene = function(){
	var aScene = cc.Scene.create();
	var aComplexAnim = new TimeEventScene();
	if (aComplexAnim.init()) {
		aScene.addChild(aComplexAnim);
		return aScene;
	}
	return null;
}