//
//  SpritesheetAnimScene.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 2/24/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var SpritesheetAnimScene = cc.Layer.extend({
	mAnims: null,
	mHUD: null,

	ctor: function(){
		this._super();
		this.mAnims = new Array(SpritesheetAnimScene.AnimNodeId.kAnimNodeCnt);
	},
	init: function(){
		if (this._super() == false) {
			return false;
		}
		
		var aScreenSize = cc.Director.getInstance().getWinSize();
		// bg
		this.addChild(cc.LayerColor.create(cc.c4(128, 128, 128, 255)));
		// no sprite sheet
		this.mAnims[SpritesheetAnimScene.AnimNodeId.kAnimNodeNoSpritesheet] = SuperAnim.SuperAnimNode.create(SAM_FISH, SpritesheetAnimScene.AnimNodeId.kAnimNodeNoSpritesheet, this);
		this.addChild(this.mAnims[SpritesheetAnimScene.AnimNodeId.kAnimNodeNoSpritesheet]);
		this.mAnims[SpritesheetAnimScene.AnimNodeId.kAnimNodeNoSpritesheet].setPosition(cc.p(aScreenSize.width * 0.25, aScreenSize.height * 0.5));
		this.mAnims[SpritesheetAnimScene.AnimNodeId.kAnimNodeNoSpritesheet].PlaySection("idle");
		var aLabel = cc.LabelTTF.create("No Sprite Sheet", "Arial", 36);
		this.addChild(aLabel);
		aLabel.setPosition(cc.p(aScreenSize.width * 0.25, aScreenSize.height * 0.35));
		
		// sprite sheet
		/*###
		this.mAnims[SpritesheetAnimScene.AnimNodeId.kAnimNodeSpritesheet] = SuperAnim.SuperAnimNode.create(SAM_FISH_SPRITESHEET, SpritesheetAnimScene.AnimNodeId.kAnimNodeSpritesheet, this);
		this.addChild(this.mAnims[SpritesheetAnimScene.AnimNodeId.kAnimNodeSpritesheet]);
		this.mAnims[SpritesheetAnimScene.AnimNodeId.kAnimNodeSpritesheet].setPosition(cc.p(aScreenSize.width * 0.75, aScreenSize.height * 0.5));
		this.mAnims[SpritesheetAnimScene.AnimNodeId.kAnimNodeSpritesheet].PlaySection("idle");
		aLabel = cc.LabelTTF.create("Sprite Sheet", "Arial", 36);
		this.addChild(aLabel);
		aLabel.setPosition(cc.p(aScreenSize.width * 0.75, aScreenSize.height * 0.35));
		*/
		
		this.mHUD = HUDLayer.create(this);
		this.addChild(this.mHUD);
		this.mHUD.mButtons[HUDLayerButton.kHUDLayerButtonPre].setEnabled(false);
		this.mHUD.mButtons[HUDLayerButton.kHUDLayerButtonNext].setEnabled(false);
		this.mHUD.mTitle.setString(getTestEntryName(TestEntry.kTestEntrySpritesheetAnim));
		
		return true;
	},
	OnAnimSectionEnd: function(theId, theLabelName){
		if (theLabelName == "idle") {
			this.mAnims[theId].PlaySection("active");
		}
		if (theLabelName == "active") {
			this.mAnims[theId].PlaySection("idle");
		}
	},
	onHUDLayerButton: function(thePressedBtn){
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonMainmenu) {
			cc.Director.getInstance().replaceScene(MainMenuScene.scene());
		}
	},
});

SpritesheetAnimScene.AnimNodeId = {
	kAnimNodeNoSpritesheet	: 0,
	kAnimNodeSpritesheet	: 1,
	
	// keep last
	kAnimNodeCnt		: 2
};

SpritesheetAnimScene.scene = function(){
	var aScene = cc.Scene.create();
	var aSpritesheetAnims = new SpritesheetAnimScene();
	if (aSpritesheetAnims.init()) {
		aScene.addChild(aSpritesheetAnims);
		return aScene;
	}
	return null;
};









