//
//  MainMenu.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 2/24/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var ENTRY_HEIGHT = 75;

var sTouchBeginPos = cc.PointZero();



var MainMenuScene = cc.Layer.extend({
	// weak reference
	mEntries: null,
	mEntryContainer: null,
	
	ctor: function(){
		this._super();
		this.mEntries = new Array(TestEntry.kTestEntryCnt);
	},
	init: function(){
	        if(this._super() == false) {
			return false;
		}
		
		var aScreenSize = cc.Director.getInstance().getWinSize();
		
		this.mEntryContainer = cc.Menu.create();
		this.addChild(this.mEntryContainer);
		this.mEntryContainer.setPosition(cc.PointZero());
		
		var anOldFontSize = cc.MenuItemFont.fontSize();
		cc.MenuItemFont.setFontSize(48);
		for (var i = 0; i < TestEntry.kTestEntryCnt; i++) {
			this.mEntries[i] = cc.MenuItemFont.create(getTestEntryName(i), this.onEntry, this);
			this.mEntryContainer.addChild(this.mEntries[i]);
			this.mEntries[i].setPosition(cc.p(aScreenSize.width * 0.5, aScreenSize.height - (i + 1) * ENTRY_HEIGHT));
		}
		cc.MenuItemFont.setFontSize(anOldFontSize);
		this.setTouchEnabled(true);
		
		return true;
	},
	ccTouchesBegan: function(pTouches, pEvent){
		var aTouch = pTouches.begin();
		sTouchBeginPos = aTouch.getLocation();
	},
	ccTouchesMoved: function(pTouches, pEvent){
		var aTouch = pTouches.begin();
		var aMovedPos = aTouch.getLocation();
		var aMovedY = aMovedPos.y - sTouchBeginPos.y;
		var aCurPos = mEntryContainer.getPosition();
		var aNextPos = ccp(aCurPos.x, aCurPos.y + aMovedY);
		var aScreenSize = cc.Director.sharedDirector().getWinSize();
		if (aNextPos.y < 0.0) {
			aNextPos.y = 0.0;
		}
		if (aNextPos.y > (kTestEntryCnt + 1) * ENTRY_HEIGHT - aScreenSize.height) {
			aNextPos.y = (kTestEntryCnt + 1) * ENTRY_HEIGHT - aScreenSize.height;
		}
		this.mEntryContainer.setPosition(aNextPos);
		sTouchBeginPos = aMovedPos;
	},
	onEntry: function(theSender){
		var aSelectedEntry = TestEntry.kTestEntryCnt;
		for (var i = 0; i < TestEntry.kTestEntryCnt; i++) {
			if (this.mEntries[i] === theSender) {
				cc.log("Main menu: entry " + i + " is selected.");
				aSelectedEntry = i;
				break;
			}
		}
		if (aSelectedEntry == TestEntry.kTestEntryBasicAnim) {
			cc.Director.getInstance().replaceScene(BasicAnimScene.scene());
		}
		if (aSelectedEntry == TestEntry.kTestEntryComplexAnim) {
			cc.Director.getInstance().replaceScene(ComplexAnimScene.scene());
		}
		if (aSelectedEntry == TestEntry.kTestEntryResizedAnim) {
			cc.Director.getInstance().replaceScene(ResizedAnimScene.scene());
		}
		if (aSelectedEntry == TestEntry.kTestEntrySpritesheetAnim) {
			cc.Director.getInstance().replaceScene(SpritesheetAnimScene.scene());
		}
		if (aSelectedEntry == TestEntry.kTestEntryTouchedAnim) {
			cc.Director.getInstance().replaceScene(TouchedAnimScene.scene());
		}
		if (aSelectedEntry == TestEntry.kTestEntryBugFix) {
			cc.Director.getInstance().replaceScene(BugFixScene.scene());
		}
		if (aSelectedEntry == TestEntry.kTestEntryFlipAnim) {
			cc.Director.getInstance().replaceScene(FlipAnimScene.scene());
		}
		if (aSelectedEntry == TestEntry.kTestEntryReplaceAnimSprite) {
			cc.Director.getInstance().replaceScene(ReplaceAnimSpriteScene.scene());
		}
		if (aSelectedEntry == TestEntry.kTestEntryTimeEvent) {
			cc.Director.getInstance().replaceScene(TimeEventScene.scene());
		}
	},
});

MainMenuScene.scene = function(){
	var aScene = cc.Scene.create();
	var aMainMenu = new MainMenuScene();
	if (aMainMenu.init()) {
		aScene.addChild(aMainMenu);
		return aScene;
	}
	return null;
};









