//
//  FlipAnimScene.js
//  super-anim-sample
//
//  Created by 卢 敬慧 on 2/25/13.
//  Created by Natural Style Co. Ltd. on 2013/05/31
//
//

var FlipAnimScene = cc.Layer.extend({
	mAnims: null,
	mHUD: null,

	ctor: function(){
		this._super();
		this.mAnims = new Array(FlipAnimScene.AnimNodeId.kAnimNodeCnt);
	},
	init: function(){
		if (this._super() == false) {
			return false;
		}
		
		var aScreenSize = cc.Director.getInstance().getWinSize();
		// bg
		this.addChild(cc.LayerColor.create(cc.c4(128, 128, 128, 255)), -1);
		// normal
		//this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeNormalFish] = SuperAnim.SuperAnimNode.create(SAM_FISH_SPRITESHEET, FlipAnimScene.AnimNodeId.kAnimNodeNormalFish, this);
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeNormalFish] = SuperAnim.SuperAnimNode.create(SAM_FISH, FlipAnimScene.AnimNodeId.kAnimNodeNormalFish, this);
		this.addChild(this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeNormalFish]);
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeNormalFish].setPosition(cc.p(aScreenSize.width * 0.25, aScreenSize.height * 0.25));
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeNormalFish].PlaySection("idle");
		// flip x
		//this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXFish] = SuperAnim.SuperAnimNode.create(SAM_FISH_SPRITESHEET, FlipAnimScene.AnimNodeId.kAnimNodeFlipXFish, this);
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXFish] = SuperAnim.SuperAnimNode.create(SAM_FISH, FlipAnimScene.AnimNodeId.kAnimNodeFlipXFish, this);
		this.addChild(this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXFish]);
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXFish].setPosition(cc.p(aScreenSize.width * 0.75, aScreenSize.height * 0.25));
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXFish].PlaySection("idle");
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXFish].setFlipX(true);
		// flip y
		//this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipYFish] = SuperAnim.SuperAnimNode.create(SAM_FISH_SPRITESHEET, FlipAnimScene.AnimNodeId.kAnimNodeFlipYFish, this);
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipYFish] = SuperAnim.SuperAnimNode.create(SAM_FISH, FlipAnimScene.AnimNodeId.kAnimNodeFlipYFish, this);
		this.addChild(this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipYFish]);
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipYFish].setPosition(cc.p(aScreenSize.width * 0.25, aScreenSize.height * 0.75));
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipYFish].PlaySection("idle");
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipYFish].setFlipY(true);
		// flip xy
		//this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXYFish] = SuperAnim.SuperAnimNode.create(SAM_FISH_SPRITESHEET, FlipAnimScene.AnimNodeId.kAnimNodeFlipXYFish, this);
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXYFish] = SuperAnim.SuperAnimNode.create(SAM_FISH, FlipAnimScene.AnimNodeId.kAnimNodeFlipXYFish, this);
		this.addChild(this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXYFish]);
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXYFish].setPosition(cc.p(aScreenSize.width * 0.75, aScreenSize.height * 0.75));
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXYFish].PlaySection("idle");
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXYFish].setFlipX(true);
		this.mAnims[FlipAnimScene.AnimNodeId.kAnimNodeFlipXYFish].setFlipY(true);
		
		this.mHUD = HUDLayer.create(this);
		this.addChild(this.mHUD);
		this.mHUD.mButtons[HUDLayerButton.kHUDLayerButtonPre].setEnabled(false);
		this.mHUD.mButtons[HUDLayerButton.kHUDLayerButtonNext].setEnabled(false);
		this.mHUD.mTitle.setString(getTestEntryName(TestEntry.kTestEntryFlipAnim));
		
		return true;
	},
	draw: function(ctx){
		this._super(ctx);
		
		for (var i = 0; i < FlipAnimScene.AnimNodeId.kAnimNodeCnt; i++) {
			if (this.mAnims[i]) {
				var aAnimRect = this.mAnims[i].getBoundingBox();
				var s = aAnimRect.size;
				var offsetPix = aAnimRect.origin;
				var vertices = [
					cc.p(offsetPix.x,offsetPix.y), cc.p(offsetPix.x+s.width,offsetPix.y),
					cc.p(offsetPix.x+s.width,offsetPix.y+s.height), cc.p(offsetPix.x,offsetPix.y+s.height)
				];
				//cc.DrawPoly(vertices, 4, true);
			}
	
		}
	},
	OnAnimSectionEnd: function(theId, theLabelName){
		if (theLabelName == "idle") {
			this.mAnims[theId].PlaySection("active");
		}
		if (theLabelName == "active") {
			this.mAnims[theId].PlaySection("idle");
		}
	},
	onHUDLayerButton: function(thePressedBtn){
		if (thePressedBtn == HUDLayerButton.kHUDLayerButtonMainmenu) {
			cc.Director.getInstance().replaceScene(MainMenuScene.scene());
		}
	},
});

FlipAnimScene.AnimNodeId = {
	kAnimNodeNormalFish	: 0,
	kAnimNodeFlipXFish	: 1,
	kAnimNodeFlipYFish	: 2,
	kAnimNodeFlipXYFish	: 3,
	
	// keep last
	kAnimNodeCnt		: 4
};

FlipAnimScene.scene = function(){
	var aScene = cc.Scene.create();
	var aFlipAnims = new FlipAnimScene();
	if (aFlipAnims.init()) {
		aScene.addChild(aFlipAnims);
		return aScene;
	}
	return null;
};









