#include <windows.h>
#include <new>
#include <httpext.h>
#include "FreeImage.h"
#include "NmagemanModule.h"









class CSampleConvRequest
{
public:
	bool	m_bGo;

public:
	CSampleConvRequest()
		: m_bGo(false)
	{
	}
};









NNmagemanModule::CFreeImageAPI*			FreeImageAPI	= 0;

unsigned char							ModuleID		= 0xFF;



NNmagemanModule::FOnConvert*			OnConvertNext;

bool OnConvert(
		LPEXTENSION_CONTROL_BLOCK				lpECB,
		NNmagemanModule::IQueryString*			pQueryString,
		NNmagemanModule::CConvertRequest&		rRequest,
		NNmagemanModule::IImageInputCached&		rInputCached,
		NNmagemanModule::IImageOutputCached&	rOutputCached
)
{
	CSampleConvRequest* pReq = new(rRequest.m_aModuleSpace[ModuleID]) CSampleConvRequest();

	const char* pValue;
	if(pValue = pQueryString->Value("grey"))
	{
		pReq->m_bGo = true;
		rRequest.m_bConvert = true;
	}

	return OnConvertNext(lpECB, pQueryString, rRequest, rInputCached, rOutputCached);
}



NNmagemanModule::FOnConvertCore*		OnConvertCoreNext;

bool OnConvertCore(
	const	NNmagemanModule::CConvertRequest&	rRequest,
			FIBITMAP*&							pInputImage,
			FIBITMAP*&							pOutputImage
)
{
	CSampleConvRequest* pReq = (CSampleConvRequest*)rRequest.m_aModuleSpace[ModuleID];

	if(OnConvertCoreNext(rRequest, pInputImage, pOutputImage) && pReq->m_bGo)
	{
		FIBITMAP* pBuf = FreeImageAPI->FreeImage_ConvertToGreyscale(pOutputImage);
		FreeImageAPI->FreeImage_Unload(pOutputImage);
		pOutputImage = pBuf;
	}

	return pOutputImage ? true : false;
}



