#ifndef H_NmagemanModule
#define H_NmagemanModule









namespace NNmagemanModule{


	
class CConvertRequest
{
public:
	bool				m_bConvert;
	void*				m_aModuleContext[0x10];
	void*				m_pContext;

public:
	unsigned char		m_aModuleSpace[0x10][0x0100];

	unsigned long		m_nWidth;
	unsigned long		m_nHeight;
	FREE_IMAGE_FORMAT	m_eFormat;

	bool				m_bEnlarge;
	FREE_IMAGE_FILTER	m_eFilter;
	int					m_nJPGQuality;	// (%)

	bool				m_bOuterBox;
	char				m_nOuterBoxHAlign;
	char				m_nOuterBoxVAlign;

	char				m_aSealFilePath[MAX_PATH];
	FILETIME			m_oSealFileTime;
	char				m_nSealHAlign;
	char				m_nSealVAlign;

	bool				m_bInnerBox;
	char				m_nInnerBoxHAlign;
	char				m_nInnerBoxVAlign;

	unsigned char		m_nInnerBoxColorRed;
	unsigned char		m_nInnerBoxColorGreen;
	unsigned char		m_nInnerBoxColorBlue;
	unsigned char		m_nInnerBoxColorAlpha;
	
	bool				m_bRotationAuto;
	int					m_nRotationAngle;

	bool m_bClearMetadata;
	bool m_aClearMetadata[12];
};



typedef bool FOnConvertCore(
	const	CConvertRequest&,
			FIBITMAP*&,
			FIBITMAP*&
);



typedef bool FOnConvertFinal(
	const	CConvertRequest&,
			FIBITMAP*&,
			FIBITMAP*&
);









class IQueryString{
public:
	virtual
	const char* Value(const char* pName) = 0;
};



class IImageInput
{
public:
	virtual
	HRESULT GetImageMemory(FIMEMORY*& pMemory) = 0;
};

class IImageOutput
{
public:
	virtual
	HRESULT PutImageMemory(FIMEMORY* qMemory) = 0;
};



class IImageInputCached
	: public IImageInput
{
public:
	virtual
	HRESULT GetCacheData(const BYTE*& rData, DWORD& rSize) = 0;

	virtual 
	HRESULT GetImageTime(FILETIME& rImageInputTime) = 0;
};

class IImageOutputCached
	: public IImageOutput
{
public:
	virtual
	HRESULT SetCacheInfo(const wchar_t* pCacheFilePath, const FILETIME& rImageInputTime) = 0;

	virtual
	HRESULT PutCacheFile() = 0;
};



typedef bool FOnConvert(
		LPEXTENSION_CONTROL_BLOCK,
		IQueryString*,
		CConvertRequest&,
		IImageInputCached&,
		IImageOutputCached&
);



// for "AllwaysSendLastModified"
class IImageInputWithTime
  : public IImageInput
{
public:
	virtual 
	HRESULT GetImageTime(FILETIME& rImageInputTime) = 0;
};

class IImageOutputWithTime
  : public IImageOutput
{
public:
	virtual
	HRESULT SetImageTime(const FILETIME& rImageInputTime) = 0;
};



class IImageInputWithTimeCached
  : public IImageInputWithTime
  , public IImageInputCached
{
};

class IImageOutputWithTimeCached
  : public IImageOutputWithTime
  , public IImageOutputCached
{
};


typedef bool FOnConvertWithTime(
		LPEXTENSION_CONTROL_BLOCK,
		IQueryString*,
		CConvertRequest&,
		IImageInputWithTimeCached&,
		IImageOutputWithTimeCached&
);






class CFreeImageAPI
{
public:
	// Init / Error routines ----------------------------------------------------

	//void (*FreeImage_Initialise)(BOOL load_local_plugins_only);
	//void (*FreeImage_DeInitialise)(void);

	// Version routines ---------------------------------------------------------

	const char *(*FreeImage_GetVersion)(void);
	const char *(*FreeImage_GetCopyrightMessage)(void);

	// Message output functions -------------------------------------------------

	//typedef void (*FreeImage_OutputMessageFunction)(FREE_IMAGE_FORMAT fif, const char *msg);
	//typedef void (*FreeImage_OutputMessageFunctionStdCall)(FREE_IMAGE_FORMAT fif, const char *msg); 

	//void (*FreeImage_SetOutputMessageStdCall)(FreeImage_OutputMessageFunctionStdCall omf); 
	//void (*FreeImage_SetOutputMessage)(FreeImage_OutputMessageFunction omf);
	//void (*FreeImage_OutputMessageProc)(int fif, const char *fmt, ...);

	// Allocate / Clone / Unload routines ---------------------------------------

	FIBITMAP *(*FreeImage_Allocate)(int width, int height, int bpp, unsigned red_mask, unsigned green_mask, unsigned blue_mask);
	FIBITMAP *(*FreeImage_AllocateT)(FREE_IMAGE_TYPE type, int width, int height, int bpp, unsigned red_mask, unsigned green_mask, unsigned blue_mask);
	FIBITMAP * (*FreeImage_Clone)(FIBITMAP *dib);
	void (*FreeImage_Unload)(FIBITMAP *dib);

	// Load / Save routines -----------------------------------------------------

	FIBITMAP *(*FreeImage_Load)(FREE_IMAGE_FORMAT fif, const char *filename, int flags);
	FIBITMAP *(*FreeImage_LoadU)(FREE_IMAGE_FORMAT fif, const wchar_t *filename, int flags);
	FIBITMAP *(*FreeImage_LoadFromHandle)(FREE_IMAGE_FORMAT fif, FreeImageIO *io, fi_handle handle, int flags);
	BOOL (*FreeImage_Save)(FREE_IMAGE_FORMAT fif, FIBITMAP *dib, const char *filename, int flags);
	BOOL (*FreeImage_SaveU)(FREE_IMAGE_FORMAT fif, FIBITMAP *dib, const wchar_t *filename, int flags);
	BOOL (*FreeImage_SaveToHandle)(FREE_IMAGE_FORMAT fif, FIBITMAP *dib, FreeImageIO *io, fi_handle handle, int flags);

	// Memory I/O stream routines -----------------------------------------------

	FIMEMORY *(*FreeImage_OpenMemory)(BYTE *data, DWORD size_in_bytes);
	void (*FreeImage_CloseMemory)(FIMEMORY *stream);
	FIBITMAP *(*FreeImage_LoadFromMemory)(FREE_IMAGE_FORMAT fif, FIMEMORY *stream, int flags);
	BOOL (*FreeImage_SaveToMemory)(FREE_IMAGE_FORMAT fif, FIBITMAP *dib, FIMEMORY *stream, int flags);
	long (*FreeImage_TellMemory)(FIMEMORY *stream);
	BOOL (*FreeImage_SeekMemory)(FIMEMORY *stream, long offset, int origin);
	BOOL (*FreeImage_AcquireMemory)(FIMEMORY *stream, BYTE **data, DWORD *size_in_bytes);
	unsigned (*FreeImage_ReadMemory)(void *buffer, unsigned size, unsigned count, FIMEMORY *stream);
	unsigned (*FreeImage_WriteMemory)(const void *buffer, unsigned size, unsigned count, FIMEMORY *stream);
	FIMULTIBITMAP *(*FreeImage_LoadMultiBitmapFromMemory)(FREE_IMAGE_FORMAT fif, FIMEMORY *stream, int flags);

	// Plugin Interface ---------------------------------------------------------

	FREE_IMAGE_FORMAT (*FreeImage_RegisterLocalPlugin)(FI_InitProc proc_address, const char *format, const char *description, const char *extension, const char *regexpr);
	FREE_IMAGE_FORMAT (*FreeImage_RegisterExternalPlugin)(const char *path, const char *format, const char *description, const char *extension, const char *regexpr);
	int (*FreeImage_GetFIFCount)(void);
	int (*FreeImage_SetPluginEnabled)(FREE_IMAGE_FORMAT fif, BOOL enable);
	int (*FreeImage_IsPluginEnabled)(FREE_IMAGE_FORMAT fif);
	FREE_IMAGE_FORMAT (*FreeImage_GetFIFFromFormat)(const char *format);
	FREE_IMAGE_FORMAT (*FreeImage_GetFIFFromMime)(const char *mime);
	const char *(*FreeImage_GetFormatFromFIF)(FREE_IMAGE_FORMAT fif);
	const char *(*FreeImage_GetFIFExtensionList)(FREE_IMAGE_FORMAT fif);
	const char *(*FreeImage_GetFIFDescription)(FREE_IMAGE_FORMAT fif);
	const char *(*FreeImage_GetFIFRegExpr)(FREE_IMAGE_FORMAT fif);
	const char *(*FreeImage_GetFIFMimeType)(FREE_IMAGE_FORMAT fif);
	FREE_IMAGE_FORMAT (*FreeImage_GetFIFFromFilename)(const char *filename);
	FREE_IMAGE_FORMAT (*FreeImage_GetFIFFromFilenameU)(const wchar_t *filename);
	BOOL (*FreeImage_FIFSupportsReading)(FREE_IMAGE_FORMAT fif);
	BOOL (*FreeImage_FIFSupportsWriting)(FREE_IMAGE_FORMAT fif);
	BOOL (*FreeImage_FIFSupportsExportBPP)(FREE_IMAGE_FORMAT fif, int bpp);
	BOOL (*FreeImage_FIFSupportsExportType)(FREE_IMAGE_FORMAT fif, FREE_IMAGE_TYPE type);
	BOOL (*FreeImage_FIFSupportsICCProfiles)(FREE_IMAGE_FORMAT fif);

	// Multipaging interface ----------------------------------------------------

	FIMULTIBITMAP * (*FreeImage_OpenMultiBitmap)(FREE_IMAGE_FORMAT fif, const char *filename, BOOL create_new, BOOL read_only, BOOL keep_cache_in_memory, int flags);
	BOOL (*FreeImage_CloseMultiBitmap)(FIMULTIBITMAP *bitmap, int flags);
	int (*FreeImage_GetPageCount)(FIMULTIBITMAP *bitmap);
	void (*FreeImage_AppendPage)(FIMULTIBITMAP *bitmap, FIBITMAP *data);
	void (*FreeImage_InsertPage)(FIMULTIBITMAP *bitmap, int page, FIBITMAP *data);
	void (*FreeImage_DeletePage)(FIMULTIBITMAP *bitmap, int page);
	FIBITMAP * (*FreeImage_LockPage)(FIMULTIBITMAP *bitmap, int page);
	void (*FreeImage_UnlockPage)(FIMULTIBITMAP *bitmap, FIBITMAP *data, BOOL changed);
	BOOL (*FreeImage_MovePage)(FIMULTIBITMAP *bitmap, int target, int source);
	BOOL (*FreeImage_GetLockedPageNumbers)(FIMULTIBITMAP *bitmap, int *pages, int *count);

	// Filetype request routines ------------------------------------------------

	FREE_IMAGE_FORMAT (*FreeImage_GetFileType)(const char *filename, int size);
	FREE_IMAGE_FORMAT (*FreeImage_GetFileTypeU)(const wchar_t *filename, int size);
	FREE_IMAGE_FORMAT (*FreeImage_GetFileTypeFromHandle)(FreeImageIO *io, fi_handle handle, int size);
	FREE_IMAGE_FORMAT (*FreeImage_GetFileTypeFromMemory)(FIMEMORY *stream, int size);

	// Image type request routine -----------------------------------------------

	FREE_IMAGE_TYPE (*FreeImage_GetImageType)(FIBITMAP *dib);

	// FreeImage helper routines ------------------------------------------------

	BOOL (*FreeImage_IsLittleEndian)(void);
	BOOL (*FreeImage_LookupX11Color)(const char *szColor, BYTE *nRed, BYTE *nGreen, BYTE *nBlue);
	BOOL (*FreeImage_LookupSVGColor)(const char *szColor, BYTE *nRed, BYTE *nGreen, BYTE *nBlue);


	// Pixel access routines ----------------------------------------------------

	BYTE *(*FreeImage_GetBits)(FIBITMAP *dib);
	BYTE *(*FreeImage_GetScanLine)(FIBITMAP *dib, int scanline);

	BOOL (*FreeImage_GetPixelIndex)(FIBITMAP *dib, unsigned x, unsigned y, BYTE *value);
	BOOL (*FreeImage_GetPixelColor)(FIBITMAP *dib, unsigned x, unsigned y, RGBQUAD *value);
	BOOL (*FreeImage_SetPixelIndex)(FIBITMAP *dib, unsigned x, unsigned y, BYTE *value);
	BOOL (*FreeImage_SetPixelColor)(FIBITMAP *dib, unsigned x, unsigned y, RGBQUAD *value);

	// DIB info routines --------------------------------------------------------

	unsigned (*FreeImage_GetColorsUsed)(FIBITMAP *dib);
	unsigned (*FreeImage_GetBPP)(FIBITMAP *dib);
	unsigned (*FreeImage_GetWidth)(FIBITMAP *dib);
	unsigned (*FreeImage_GetHeight)(FIBITMAP *dib);
	unsigned (*FreeImage_GetLine)(FIBITMAP *dib);
	unsigned (*FreeImage_GetPitch)(FIBITMAP *dib);
	unsigned (*FreeImage_GetDIBSize)(FIBITMAP *dib);
	RGBQUAD *(*FreeImage_GetPalette)(FIBITMAP *dib);

	unsigned (*FreeImage_GetDotsPerMeterX)(FIBITMAP *dib);
	unsigned (*FreeImage_GetDotsPerMeterY)(FIBITMAP *dib);
	void (*FreeImage_SetDotsPerMeterX)(FIBITMAP *dib, unsigned res);
	void (*FreeImage_SetDotsPerMeterY)(FIBITMAP *dib, unsigned res);

	BITMAPINFOHEADER *(*FreeImage_GetInfoHeader)(FIBITMAP *dib);
	BITMAPINFO *(*FreeImage_GetInfo)(FIBITMAP *dib);
	FREE_IMAGE_COLOR_TYPE (*FreeImage_GetColorType)(FIBITMAP *dib);

	unsigned (*FreeImage_GetRedMask)(FIBITMAP *dib);
	unsigned (*FreeImage_GetGreenMask)(FIBITMAP *dib);
	unsigned (*FreeImage_GetBlueMask)(FIBITMAP *dib);

	unsigned (*FreeImage_GetTransparencyCount)(FIBITMAP *dib);
	BYTE * (*FreeImage_GetTransparencyTable)(FIBITMAP *dib);
	void (*FreeImage_SetTransparent)(FIBITMAP *dib, BOOL enabled);
	void (*FreeImage_SetTransparencyTable)(FIBITMAP *dib, BYTE *table, int count);
	BOOL (*FreeImage_IsTransparent)(FIBITMAP *dib);
	void (*FreeImage_SetTransparentIndex)(FIBITMAP *dib, int index);
	int (*FreeImage_GetTransparentIndex)(FIBITMAP *dib);

	BOOL (*FreeImage_HasBackgroundColor)(FIBITMAP *dib);
	BOOL (*FreeImage_GetBackgroundColor)(FIBITMAP *dib, RGBQUAD *bkcolor);
	BOOL (*FreeImage_SetBackgroundColor)(FIBITMAP *dib, RGBQUAD *bkcolor);


	// ICC profile routines -----------------------------------------------------

	FIICCPROFILE *(*FreeImage_GetICCProfile)(FIBITMAP *dib);
	FIICCPROFILE *(*FreeImage_CreateICCProfile)(FIBITMAP *dib, void *data, long size);
	void (*FreeImage_DestroyICCProfile)(FIBITMAP *dib);

	// Line conversion routines -------------------------------------------------

	void (*FreeImage_ConvertLine1To4)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine8To4)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine16To4_555)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine16To4_565)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine24To4)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine32To4)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine1To8)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine4To8)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine16To8_555)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine16To8_565)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine24To8)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine32To8)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine1To16_555)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine4To16_555)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine8To16_555)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine16_565_To16_555)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine24To16_555)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine32To16_555)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine1To16_565)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine4To16_565)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine8To16_565)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine16_555_To16_565)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine24To16_565)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine32To16_565)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine1To24)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine4To24)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine8To24)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine16To24_555)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine16To24_565)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine32To24)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine1To32)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine4To32)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine8To32)(BYTE *target, BYTE *source, int width_in_pixels, RGBQUAD *palette);
	void (*FreeImage_ConvertLine16To32_555)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine16To32_565)(BYTE *target, BYTE *source, int width_in_pixels);
	void (*FreeImage_ConvertLine24To32)(BYTE *target, BYTE *source, int width_in_pixels);

	// Smart conversion routines ------------------------------------------------

	FIBITMAP *(*FreeImage_ConvertTo4Bits)(FIBITMAP *dib);
	FIBITMAP *(*FreeImage_ConvertTo8Bits)(FIBITMAP *dib);
	FIBITMAP *(*FreeImage_ConvertToGreyscale)(FIBITMAP *dib);
	FIBITMAP *(*FreeImage_ConvertTo16Bits555)(FIBITMAP *dib);
	FIBITMAP *(*FreeImage_ConvertTo16Bits565)(FIBITMAP *dib);
	FIBITMAP *(*FreeImage_ConvertTo24Bits)(FIBITMAP *dib);
	FIBITMAP *(*FreeImage_ConvertTo32Bits)(FIBITMAP *dib);
	FIBITMAP *(*FreeImage_ColorQuantize)(FIBITMAP *dib, FREE_IMAGE_QUANTIZE quantize);
	FIBITMAP *(*FreeImage_ColorQuantizeEx)(FIBITMAP *dib, FREE_IMAGE_QUANTIZE quantize, int PaletteSize, int ReserveSize, RGBQUAD *ReservePalette);
	FIBITMAP *(*FreeImage_Threshold)(FIBITMAP *dib, BYTE T);
	FIBITMAP *(*FreeImage_Dither)(FIBITMAP *dib, FREE_IMAGE_DITHER algorithm);

	FIBITMAP *(*FreeImage_ConvertFromRawBits)(BYTE *bits, int width, int height, int pitch, unsigned bpp, unsigned red_mask, unsigned green_mask, unsigned blue_mask, BOOL topdown);
	void (*FreeImage_ConvertToRawBits)(BYTE *bits, FIBITMAP *dib, int pitch, unsigned bpp, unsigned red_mask, unsigned green_mask, unsigned blue_mask, BOOL topdown);

	FIBITMAP *(*FreeImage_ConvertToRGBF)(FIBITMAP *dib);

	FIBITMAP *(*FreeImage_ConvertToStandardType)(FIBITMAP *src, BOOL scale_linear);
	FIBITMAP *(*FreeImage_ConvertToType)(FIBITMAP *src, FREE_IMAGE_TYPE dst_type, BOOL scale_linear);

	// tone mapping operators
	FIBITMAP *(*FreeImage_ToneMapping)(FIBITMAP *dib, FREE_IMAGE_TMO tmo, double first_param, double second_param);
	FIBITMAP *(*FreeImage_TmoDrago03)(FIBITMAP *src, double gamma, double exposure);
	FIBITMAP *(*FreeImage_TmoReinhard05)(FIBITMAP *src, double intensity, double contrast);
	FIBITMAP *(*FreeImage_TmoFattal02)(FIBITMAP *src, double color_saturation, double attenuation);

	// ZLib interface -----------------------------------------------------------

	DWORD (*FreeImage_ZLibCompress)(BYTE *target, DWORD target_size, BYTE *source, DWORD source_size);
	DWORD (*FreeImage_ZLibUncompress)(BYTE *target, DWORD target_size, BYTE *source, DWORD source_size);
	DWORD (*FreeImage_ZLibGZip)(BYTE *target, DWORD target_size, BYTE *source, DWORD source_size);
	DWORD (*FreeImage_ZLibGUnzip)(BYTE *target, DWORD target_size, BYTE *source, DWORD source_size);
	DWORD (*FreeImage_ZLibCRC32)(DWORD crc, BYTE *source, DWORD source_size);

	// --------------------------------------------------------------------------
	// Metadata routines --------------------------------------------------------
	// --------------------------------------------------------------------------

	// tag creation / destruction
	FITAG *(*FreeImage_CreateTag)();
	void (*FreeImage_DeleteTag)(FITAG *tag);
	FITAG *(*FreeImage_CloneTag)(FITAG *tag);

	// tag getters and setters
	const char *(*FreeImage_GetTagKey)(FITAG *tag);
	const char *(*FreeImage_GetTagDescription)(FITAG *tag);
	WORD (*FreeImage_GetTagID)(FITAG *tag);
	FREE_IMAGE_MDTYPE (*FreeImage_GetTagType)(FITAG *tag);
	DWORD (*FreeImage_GetTagCount)(FITAG *tag);
	DWORD (*FreeImage_GetTagLength)(FITAG *tag);
	const void *(*FreeImage_GetTagValue)(FITAG *tag);

	BOOL (*FreeImage_SetTagKey)(FITAG *tag, const char *key);
	BOOL (*FreeImage_SetTagDescription)(FITAG *tag, const char *description);
	BOOL (*FreeImage_SetTagID)(FITAG *tag, WORD id);
	BOOL (*FreeImage_SetTagType)(FITAG *tag, FREE_IMAGE_MDTYPE type);
	BOOL (*FreeImage_SetTagCount)(FITAG *tag, DWORD count);
	BOOL (*FreeImage_SetTagLength)(FITAG *tag, DWORD length);
	BOOL (*FreeImage_SetTagValue)(FITAG *tag, const void *value);

	// iterator
	FIMETADATA *(*FreeImage_FindFirstMetadata)(FREE_IMAGE_MDMODEL model, FIBITMAP *dib, FITAG **tag);
	BOOL (*FreeImage_FindNextMetadata)(FIMETADATA *mdhandle, FITAG **tag);
	void (*FreeImage_FindCloseMetadata)(FIMETADATA *mdhandle);

	// metadata setter and getter
	BOOL (*FreeImage_SetMetadata)(FREE_IMAGE_MDMODEL model, FIBITMAP *dib, const char *key, FITAG *tag);
	BOOL (*FreeImage_GetMetadata)(FREE_IMAGE_MDMODEL model, FIBITMAP *dib, const char *key, FITAG **tag);

	// helpers
	unsigned (*FreeImage_GetMetadataCount)(FREE_IMAGE_MDMODEL model, FIBITMAP *dib);

	// tag to C string conversion
	const char* (*FreeImage_TagToString)(FREE_IMAGE_MDMODEL model, FITAG *tag, char *Make);

	// --------------------------------------------------------------------------
	// Image manipulation toolkit -----------------------------------------------
	// --------------------------------------------------------------------------

	// rotation and flipping
	FIBITMAP *(*FreeImage_RotateClassic)(FIBITMAP *dib, double angle);
	FIBITMAP *(*FreeImage_RotateEx)(FIBITMAP *dib, double angle, double x_shift, double y_shift, double x_origin, double y_origin, BOOL use_mask);
	BOOL (*FreeImage_FlipHorizontal)(FIBITMAP *dib);
	BOOL (*FreeImage_FlipVertical)(FIBITMAP *dib);
	BOOL (*FreeImage_JPEGTransform)(const char *src_file, const char *dst_file, FREE_IMAGE_JPEG_OPERATION operation, BOOL perfect);

	// upsampling / downsampling
	FIBITMAP *(*FreeImage_Rescale)(FIBITMAP *dib, int dst_width, int dst_height, FREE_IMAGE_FILTER filter);
	FIBITMAP *(*FreeImage_MakeThumbnail)(FIBITMAP *dib, int max_pixel_size, BOOL convert);

	// color manipulation routines (point operations)
	BOOL (*FreeImage_AdjustCurve)(FIBITMAP *dib, BYTE *LUT, FREE_IMAGE_COLOR_CHANNEL channel);
	BOOL (*FreeImage_AdjustGamma)(FIBITMAP *dib, double gamma);
	BOOL (*FreeImage_AdjustBrightness)(FIBITMAP *dib, double percentage);
	BOOL (*FreeImage_AdjustContrast)(FIBITMAP *dib, double percentage);
	BOOL (*FreeImage_Invert)(FIBITMAP *dib);
	BOOL (*FreeImage_GetHistogram)(FIBITMAP *dib, DWORD *histo, FREE_IMAGE_COLOR_CHANNEL channel);
	int (*FreeImage_GetAdjustColorsLookupTable)(BYTE *LUT, double brightness, double contrast, double gamma, BOOL invert);
	BOOL (*FreeImage_AdjustColors)(FIBITMAP *dib, double brightness, double contrast, double gamma, BOOL invert);
	unsigned (*FreeImage_ApplyColorMapping)(FIBITMAP *dib, RGBQUAD *srccolors, RGBQUAD *dstcolors, unsigned count, BOOL ignore_alpha, BOOL swap);
	unsigned (*FreeImage_SwapColors)(FIBITMAP *dib, RGBQUAD *color_a, RGBQUAD *color_b, BOOL ignore_alpha);
	unsigned (*FreeImage_ApplyPaletteIndexMapping)(FIBITMAP *dib, BYTE *srcindices,	BYTE *dstindices, unsigned count, BOOL swap);
	unsigned (*FreeImage_SwapPaletteIndices)(FIBITMAP *dib, BYTE *index_a, BYTE *index_b);

	// channel processing routines
	FIBITMAP *(*FreeImage_GetChannel)(FIBITMAP *dib, FREE_IMAGE_COLOR_CHANNEL channel);
	BOOL (*FreeImage_SetChannel)(FIBITMAP *dib, FIBITMAP *dib8, FREE_IMAGE_COLOR_CHANNEL channel);
	FIBITMAP *(*FreeImage_GetComplexChannel)(FIBITMAP *src, FREE_IMAGE_COLOR_CHANNEL channel);
	BOOL (*FreeImage_SetComplexChannel)(FIBITMAP *dst, FIBITMAP *src, FREE_IMAGE_COLOR_CHANNEL channel);

	// copy / paste / composite routines
	FIBITMAP *(*FreeImage_Copy)(FIBITMAP *dib, int left, int top, int right, int bottom);
	BOOL (*FreeImage_Paste)(FIBITMAP *dst, FIBITMAP *src, int left, int top, int alpha);
	FIBITMAP *(*FreeImage_Composite)(FIBITMAP *fg, BOOL useFileBkg, RGBQUAD *appBkColor, FIBITMAP *bg);
	BOOL (*FreeImage_JPEGCrop)(const char *src_file, const char *dst_file, int left, int top, int right, int bottom);
	BOOL (*FreeImage_PreMultiplyWithAlpha)(FIBITMAP *dib);

	// miscellaneous algorithms
	FIBITMAP *(*FreeImage_MultigridPoissonSolver)(FIBITMAP *Laplacian, int ncycle);


};
//--



};









#endif //H_NmagemanModule
